/*
 * Decompiled with CFR 0.152.
 */
package de.renew.unify;

import de.renew.unify.Calculator;
import de.renew.unify.Copier;
import de.renew.unify.IStateRecorder;
import de.renew.unify.Impossible;
import de.renew.unify.List;
import de.renew.unify.Notifiable;
import de.renew.unify.Reference;
import de.renew.unify.Referer;
import de.renew.unify.SilentlyUnifiable;
import de.renew.unify.Tuple;
import de.renew.unify.Unifiable;
import de.renew.unify.Unknown;
import de.renew.unify.Variable;
import java.util.HashSet;
import java.util.Set;

public final class Unify {
    private static final Copier TEMP_COPIER = new Copier();

    private Unify() {
    }

    static Reference[] cleanupReferenceArray(Object[] orgArray, Referer referer, IStateRecorder recorder) {
        Reference[] references = new Reference[orgArray.length];
        for (int i = 0; i < orgArray.length; ++i) {
            references[i] = new Reference(orgArray[i], referer, recorder);
        }
        return references;
    }

    static Reference[] makeReferenceArray(Object initValue, Referer referer, IStateRecorder recorder) {
        Reference[] references = new Reference[]{new Reference(initValue, referer, recorder)};
        return references;
    }

    static Reference[] makeUnknownReferenceArray(int arity, Referer referer) {
        Reference[] references = new Reference[arity];
        for (int i = 0; i < arity; ++i) {
            references[i] = new Reference(new Unknown(), referer, null);
        }
        return references;
    }

    static boolean isComplete(Object o) {
        if (o instanceof Unifiable) {
            Unifiable unifiable = (Unifiable)o;
            return unifiable.isComplete();
        }
        return true;
    }

    public static boolean isBound(Object o) {
        if (o instanceof Unifiable) {
            Unifiable unifiable = (Unifiable)o;
            return unifiable.isBound();
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void unifySilently(Object left, Object right, IStateRecorder recorder, Set<Notifiable> listeners) throws Impossible {
        if (left instanceof Variable) {
            Variable leftVariable = (Variable)left;
            left = leftVariable.getValue();
        }
        if (right instanceof Variable) {
            Variable rightVariable = (Variable)right;
            right = rightVariable.getValue();
        }
        if (left == right) {
            return;
        }
        if (left instanceof SilentlyUnifiable) {
            SilentlyUnifiable unifiable = (SilentlyUnifiable)left;
            unifiable.unifySilently(right, recorder, listeners);
            return;
        } else if (left instanceof Unknown) {
            Unknown unknown = (Unknown)left;
            unknown.unifySilently(right, recorder, listeners);
            return;
        } else if (right instanceof Unknown) {
            Unknown unknown = (Unknown)right;
            unknown.unifySilently(left, recorder, listeners);
            return;
        } else if (left instanceof Tuple) {
            Tuple leftTuple = (Tuple)left;
            if (!(right instanceof Tuple)) throw new Impossible();
            Tuple rightTuple = (Tuple)right;
            leftTuple.unifySilently(rightTuple, recorder, listeners);
            return;
        } else if (left instanceof List) {
            List leftList = (List)left;
            if (!(right instanceof List)) throw new Impossible();
            List rightList = (List)right;
            leftList.unifySilently(rightList, recorder, listeners);
            return;
        } else {
            if (left == null || right == null || left instanceof Calculator || right instanceof Calculator) {
                throw new Impossible();
            }
            if (left.equals(right)) return;
            throw new Impossible();
        }
    }

    public static void unify(Object left, Object right, IStateRecorder recorder) throws Impossible {
        HashSet<Notifiable> listeners = new HashSet<Notifiable>();
        Unify.unifySilently(left, right, recorder, listeners);
        for (Notifiable listener : listeners) {
            listener.boundNotify(recorder);
        }
    }

    public static Object copyBoundValue(Object val) {
        if (!Unify.isBound(val)) {
            throw new RuntimeException("To copy unbound values, use a copier.");
        }
        return TEMP_COPIER.copy(val);
    }
}

