/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.parse;

import de.renew.formalism.java.JavaNetParser;
import de.renew.formalism.java.JavaNetParserTokenManager;
import de.renew.formalism.java.ParseException;
import de.renew.formalism.java.ParsedDeclarationNode;
import de.renew.formalism.java.Token;
import de.renew.net.inscription.TransitionInscription;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class JNPParser {
    private static final Logger LOGGER = Logger.getLogger(JNPParser.class);

    private JNPParser() {
    }

    public static JavaNetParser netParser(String input) {
        return JNPParser.netParser(input, new ParsedDeclarationNode());
    }

    public static JavaNetParser netParser(String input, ParsedDeclarationNode declarationNode) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(input.getBytes());
        JavaNetParser netParser = new JavaNetParser((InputStream)inputStream);
        netParser.refactoring = true;
        netParser.setDeclarationNode(declarationNode);
        return netParser;
    }

    public static JavaNetParserTokenManager tokenManager(JavaNetParser netParser) {
        return netParser.token_source;
    }

    public static boolean isIdentifier(JavaNetParser netParser) {
        JavaNetParserTokenManager tokenManager = JNPParser.tokenManager(netParser);
        Token token = tokenManager.getNextToken();
        boolean isOnlyToken = tokenManager.getNextToken().kind == 0;
        return isOnlyToken && token.kind == 70;
    }

    public static ParsedDeclarationNode declarationNode(String input) {
        try {
            return JNPParser.netParser(input).DeclarationNode();
        }
        catch (ParseException e) {
            LOGGER.debug((Object)("Declaration node could not be parsed: " + input + ", " + e.getMessage()));
            return null;
        }
    }

    public static Collection<TransitionInscription> transitionInscriptions(JavaNetParser netParser) {
        try {
            return netParser.TransitionInscription(false, null);
        }
        catch (ParseException e) {
            LOGGER.debug((Object)e.getMessage());
            return Collections.emptyList();
        }
    }

    public static TransitionInscription firstInscription(JavaNetParser netParser) {
        Iterator<TransitionInscription> iterator = JNPParser.transitionInscriptions(netParser).iterator();
        if (iterator.hasNext()) {
            TransitionInscription inscription = iterator.next();
            return inscription;
        }
        return null;
    }
}

