/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.search.range;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.refactoring.search.range.DrawingSearchRange;
import de.renew.refactoring.search.range.MakeDrawingIterator;
import de.renew.refactoring.search.range.NetpathFiles;
import de.renew.refactoring.search.range.OpenedDrawingsSearchRange;
import de.renew.refactoring.util.DrawingHelper;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class NetpathDrawingsSearchRange
implements DrawingSearchRange {
    private static final Logger LOGGER = Logger.getLogger(NetpathDrawingsSearchRange.class);
    private final int _numberOfDrawings;
    private final Iterator<Drawing> _drawings;

    public NetpathDrawingsSearchRange(List<String> extensions) {
        List<Drawing> openedDrawings = DrawingHelper.toDrawingList(new OpenedDrawingsSearchRange(extensions).drawings());
        List<File> netpathDrawings = NetpathFiles.files(extensions, "");
        List<Object> drawings = DrawingHelper.mergeDrawingLists(openedDrawings, netpathDrawings);
        this._numberOfDrawings = drawings.size();
        this._drawings = new MakeDrawingIterator(drawings);
    }

    public NetpathDrawingsSearchRange(String extension) {
        this(Collections.singletonList(extension));
    }

    @Override
    public String description() {
        return "Netpath drawings";
    }

    @Override
    public int numberOfDrawings() {
        return this._numberOfDrawings;
    }

    @Override
    public Iterator<Drawing> drawings() {
        return this._drawings;
    }
}

