/*
 * Decompiled with CFR 0.152.
 */
package de.renew.refactoring.util;

import de.renew.refactoring.match.StringMatch;

public class StringHelper {
    private StringHelper() {
    }

    public static String replaceRange(String string, int start, int end, String replacement) {
        assert (start >= 0);
        assert (end >= start);
        assert (end <= string.length());
        return string.substring(0, start) + replacement + string.substring(end, string.length());
    }

    public static String substringWithContext(String string, int substringStart, int substringEnd, int length) {
        String boldSubstring = "<strong>" + string.substring(substringStart, substringEnd) + "</strong>";
        String oneline = string.replace('\n', ' ');
        StringBuilder sb = new StringBuilder(length);
        sb.append("<html>");
        if (length < substringEnd - substringStart) {
            sb.append(boldSubstring);
        } else {
            int padding = length - (substringEnd - substringStart);
            int carry = length % 2 == 0 ? 0 : 1;
            int contextStart = Math.max(0, substringStart - (padding / 2 + carry));
            int contextEnd = Math.min(oneline.length(), substringEnd + padding / 2);
            if (contextStart > 0) {
                sb.append("...");
            }
            sb.append(oneline.substring(contextStart, substringStart));
            sb.append(boldSubstring);
            sb.append(oneline.substring(substringEnd, contextEnd));
            if (contextEnd < oneline.length()) {
                sb.append("...");
            }
        }
        sb.append("</html>");
        return sb.toString();
    }

    public static int indexForLineAndColumn(String string, int line, int col) {
        String[] lines = string.split("\n");
        int index = 0;
        int i = 0;
        while (i + 1 < line) {
            index += lines[i].length();
            ++index;
            ++i;
        }
        return index + (col - 1);
    }

    public static StringMatch makeStringMatch(String string, int beginLine, int beginColumn, int endLine, int endColumn) {
        int beginIndex = StringHelper.indexForLineAndColumn(string, beginLine, beginColumn);
        int endIndex = StringHelper.indexForLineAndColumn(string, endLine, endColumn) + 1;
        String match = string.substring(beginIndex, endIndex);
        return new StringMatch(match, beginIndex, endIndex);
    }
}

