/*
 * Decompiled with CFR 0.152.
 */
package de.renew.navigator.vc.git;

import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.io.StorableInputDrawingLoader;
import de.renew.draw.storables.api.StorableApi;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.ui.ontology.StatusDisplayer;
import de.renew.imagenetdiff.PNGDiffCommand;
import de.renew.logging.CliColor;
import de.renew.navigator.vc.AbstractVersionControl;
import de.renew.navigator.vc.Repository;
import de.renew.navigator.vc.StdoutStatusDisplayer;
import de.renew.navigator.vc.git.GitRepository;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import org.eclipse.jgit.api.LogCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.storage.file.FileRepository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.gitective.core.BlobUtils;

public class GitVersionControl
extends AbstractVersionControl {
    public boolean diff(File file) {
        LOGGER.debug((Object)("diff with head: " + file.getAbsolutePath()));
        try {
            String bytes;
            GitRepository repository = this.buildGitRepository(file);
            URI relative = repository.makeRelativeURI(file);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Git Repository Branch:  " + repository.getBranch()));
                LOGGER.debug((Object)("Git file path:          " + file.getPath()));
                LOGGER.debug((Object)("Git relative file path: " + relative.getPath()));
            }
            if ((bytes = BlobUtils.getContent((org.eclipse.jgit.lib.Repository)repository._fileRepository, (String)"HEAD", (String)relative.getPath())) == null) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info((Object)"Git: There is no HEAD here. File possibly not in repository. Received null.");
                }
                return false;
            }
            Drawing drawing = StorableInputDrawingLoader.readStorableDrawing((StorableInput)StorableApi.createStorableInput((String)bytes));
            StdoutStatusDisplayer displayer = new StdoutStatusDisplayer();
            Drawing drawing2 = DrawingFileHelper.loadDrawing((File)file.getAbsoluteFile(), (StatusDisplayer)displayer);
            if (drawing2 == null) {
                LOGGER.warn((Object)("Something went wrong. Given Drawing could not be loaded: " + drawing.getName()));
                return false;
            }
            drawing.setName(drawing2.getName() + "[HEAD]");
            PNGDiffCommand diffCommand = new PNGDiffCommand();
            diffCommand.doDiff((StatusDisplayer)displayer, drawing, drawing2, false);
            return true;
        }
        catch (IOException exception) {
            this.errorException(exception, "performing diff with head");
            return false;
        }
    }

    public boolean log(File file) {
        try {
            boolean result = false;
            GitRepository repository = this.buildGitRepository(file);
            LogCommand log2 = repository._git.log();
            URI relative = repository.makeRelativeURI(file);
            LOGGER.info((Object)("Branch: " + repository.getBranch() + " File: " + String.valueOf(relative) + "\n Revisions: "));
            Iterable call = log2.addPath(relative.getPath()).call();
            for (RevCommit revCommit : call) {
                System.out.println("\n\n" + CliColor.color((String)revCommit.toString(), (CliColor[])new CliColor[]{CliColor.BLUE}) + "\n" + CliColor.color((String)("Author: " + revCommit.getAuthorIdent().getEmailAddress() + "\nDate:   " + String.valueOf(revCommit.getAuthorIdent().getWhen())), (CliColor[])new CliColor[]{CliColor.WHITE}) + "\n\n" + revCommit.getFullMessage().replaceAll("(?m)^", "\t"));
                result = true;
            }
            return result;
        }
        catch (GitAPIException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public File findRootDirectory(File fileInRepository) {
        FileRepositoryBuilder repositoryBuilder = new FileRepositoryBuilder();
        ((FileRepositoryBuilder)((FileRepositoryBuilder)repositoryBuilder.findGitDir(fileInRepository)).setMustExist(true)).readEnvironment();
        return Optional.ofNullable(repositoryBuilder.getGitDir()).map(File::getParentFile).orElse(null);
    }

    protected Repository buildRepository(File fileInRepository) {
        return this.buildGitRepository(fileInRepository);
    }

    protected GitRepository buildGitRepository(File fileInRepository) {
        LOGGER.debug((Object)("Locating Git repository for [" + String.valueOf(fileInRepository) + "]"));
        FileRepositoryBuilder repositoryBuilder = new FileRepositoryBuilder();
        ((FileRepositoryBuilder)((FileRepositoryBuilder)repositoryBuilder.findGitDir(fileInRepository)).setMustExist(true)).readEnvironment();
        if (null == repositoryBuilder.getGitDir()) {
            LOGGER.debug((Object)("This is not in a Git repo   [" + String.valueOf(fileInRepository) + "]"));
            return null;
        }
        try {
            FileRepository repository = repositoryBuilder.build();
            System.out.println(repository);
            return new GitRepository(repository, this);
        }
        catch (IOException | IllegalArgumentException e) {
            LOGGER.error((Object)"Unable to locate Git repo", (Throwable)e);
            return null;
        }
    }

    public boolean displayListForFile(File file) {
        try {
            boolean result = false;
            GitRepository repository = this.buildGitRepository(file);
            LogCommand log2 = repository._git.log();
            URI relative = repository.makeRelativeURI(file);
            LOGGER.info((Object)("Branch: " + repository.getBranch()));
            LOGGER.info((Object)("File:   " + String.valueOf(relative)));
            Iterable call = log2.addPath(relative.getPath()).call();
            for (RevCommit revCommit : call) {
                LOGGER.info((Object)("Revisions: " + revCommit.toString()));
                result = true;
            }
            return result;
        }
        catch (GitAPIException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

