/*
 * Decompiled with CFR 0.152.
 */
package de.renew.windowmanagement;

import de.renew.plugin.Loader;
import de.renew.plugin.PluginManager;
import de.renew.propertymanagement.prop.ConfigurablePropertyManager;
import de.renew.propertymanagement.prop.PropertySaveFailedException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Optional;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class UIScaleMenuExtender {
    private static final Logger LOGGER = Logger.getLogger(UIScaleMenuExtender.class);
    private static final String UI_SCALE_PROPERTY = "sun.java2d.uiScale";
    private static final String ITEM_TEXT = "UI Scale";
    private static final String WARNING_TEXT = "Fractional scaling values may be ignored. Try e.g \"200\" (for 200% scaling) instead.";
    private static final String INPUT_TITLE = "Set UI Scale (in %)";
    private static final String ERROR_TITLE = "Error";
    private static final String ERROR_TEXT = "Saving properties failed.";
    private static final String SUCCESS_TITLE = "Restart required";
    private static final String SUCCESS_MESSAGE = "Properties saved. A restart of Renew is required to apply the changes. Do you want to restart now?";

    public static Collection<JMenuItem> createMenus() {
        ArrayList<JMenuItem> items = new ArrayList<JMenuItem>();
        JMenuItem item = new JMenuItem(ITEM_TEXT);
        item.addActionListener(event -> {
            double currentUIScale = Double.parseDouble(UIScaleMenuExtender.getUIScaleProperty());
            JSpinner spinner = new JSpinner(new SpinnerNumberModel((int)(currentUIScale * 100.0), 50, 500, 25));
            spinner.setEditor(new JSpinner.NumberEditor(spinner, "#"));
            JLabel warning = new JLabel(WARNING_TEXT);
            warning.setFont(warning.getFont().deriveFont(2));
            JPanel panel = new JPanel(new BorderLayout(5, 5));
            panel.add((Component)spinner, "North");
            panel.add((Component)warning, "South");
            int result = JOptionPane.showConfirmDialog(null, panel, INPUT_TITLE, 2, -1);
            if (result != 0) {
                return;
            }
            double customUIScale = ((Number)spinner.getValue()).doubleValue() / 100.0;
            if (!UIScaleMenuExtender.setUIScaleProperty(Double.toString(customUIScale))) {
                JOptionPane.showMessageDialog(null, ERROR_TEXT, ERROR_TITLE, 0);
                return;
            }
            int result2 = JOptionPane.showConfirmDialog(null, SUCCESS_MESSAGE, SUCCESS_TITLE, 0);
            if (result2 == 0) {
                Thread restart = new Thread(() -> {
                    try {
                        Loader.startNewRenewInstance();
                    }
                    catch (IOException e) {
                        LOGGER.error((Object)"Restart of Renew failed.", (Throwable)e);
                    }
                });
                Runtime.getRuntime().addShutdownHook(restart);
                PluginManager.getInstance().stop();
            }
        });
        items.add(item);
        return items;
    }

    private static boolean setUIScaleProperty(String customUIScale) {
        ConfigurablePropertyManager propertyManager = ConfigurablePropertyManager.getInstance();
        propertyManager.changeProperty(UI_SCALE_PROPERTY, customUIScale);
        try {
            propertyManager.saveProperties(true);
        }
        catch (PropertySaveFailedException e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    private static String getUIScaleProperty() {
        try {
            Optional prop = ConfigurablePropertyManager.getInstance().getCurrentValueForProperty(UI_SCALE_PROPERTY);
            if (prop.isPresent()) {
                return (String)prop.get();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return Double.toString(UIScaleMenuExtender.getAppliedUIScale());
    }

    public static double getAppliedUIScale() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getDefaultTransform().getScaleX();
    }
}

