/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.java;

import de.renew.expression.CallExpression;
import de.renew.expression.Expression;
import de.renew.expression.Function;
import de.renew.expression.InvertibleExpression;
import de.renew.formalism.function.CastFunction;
import de.renew.formalism.java.JavaHelper;
import de.renew.formalism.java.TypedExpression;
import de.renew.simulatorontology.shadow.SyntaxException;
import de.renew.util.Types;

public class JavaNetHelper {
    public static Expression makeCastedOutputExpression(Class<?> type, TypedExpression expr) throws SyntaxException {
        if (type == Types.UNTYPED) {
            return expr.getExpression();
        }
        if (expr.getType() == Types.UNTYPED) {
            throw new SyntaxException("Output arc expression for typed place must be typed.");
        }
        if (type == expr.getType()) {
            return expr.getExpression();
        }
        if (Types.allowsLosslessWidening(expr.getType(), type)) {
            if (type.isPrimitive()) {
                return new CallExpression(type, expr.getExpression(), (Function)new CastFunction(type));
            }
            return expr.getExpression();
        }
        throw new SyntaxException("Cannot losslessly convert " + JavaHelper.makeTypeErrorString(expr.getType()) + " to " + JavaHelper.makeTypeErrorString(type) + ".");
    }

    public static Expression makeCastedInputExpression(Class<?> type, TypedExpression expr) throws SyntaxException {
        if (type == Types.UNTYPED) {
            return JavaHelper.makeGuardedExpression(expr);
        }
        if (expr.getType() == Types.UNTYPED) {
            return expr.getExpression();
        }
        if (type == expr.getType()) {
            return expr.getExpression();
        }
        if (Types.allowsLosslessWidening(type, expr.getType())) {
            if (type.isPrimitive()) {
                return new InvertibleExpression(type, expr.getExpression(), (Function)new CastFunction(type), (Function)new CastFunction(expr.getType()));
            }
            return expr.getExpression();
        }
        if (Types.allowsLosslessWidening(expr.getType(), type)) {
            if (type.isPrimitive()) {
                return new InvertibleExpression(type, expr.getExpression(), (Function)new CastFunction(type), (Function)new CastFunction(expr.getType()));
            }
            return JavaHelper.makeGuardedExpression(expr);
        }
        throw new SyntaxException("Cannot losslessly convert " + JavaHelper.makeTypeErrorString(expr.getType()) + " to " + JavaHelper.makeTypeErrorString(type) + " or vice versa.");
    }
}

