/*
 * Decompiled with CFR 0.152.
 */
package de.renew.formalism.pt;

import de.renew.expression.ConstantExpression;
import de.renew.expression.Expression;
import de.renew.formalism.base.AbstractSingleNetCompiler;
import de.renew.net.ConstantTokenSource;
import de.renew.net.Place;
import de.renew.net.TokenSource;
import de.renew.net.Transition;
import de.renew.net.inscription.TransitionInscription;
import de.renew.net.inscription.arc.Arc;
import de.renew.simulatorontology.shadow.ShadowArc;
import de.renew.simulatorontology.shadow.ShadowDeclarationNode;
import de.renew.simulatorontology.shadow.ShadowInscribable;
import de.renew.simulatorontology.shadow.ShadowInscription;
import de.renew.simulatorontology.shadow.ShadowNet;
import de.renew.simulatorontology.shadow.ShadowPlace;
import de.renew.simulatorontology.shadow.SyntaxException;
import de.renew.unify.Tuple;
import java.util.Collection;
import java.util.Iterator;

public class SinglePTNetCompiler
extends AbstractSingleNetCompiler {
    public String checkDeclarationNode(String inscription, boolean special, ShadowNet shadowNet) throws SyntaxException {
        throw new SyntaxException("Declaration node is not allowed.");
    }

    public String checkArcInscription(String inscription, boolean special, ShadowNet shadowNet) throws SyntaxException {
        SinglePTNetCompiler.parseNumber(inscription);
        return "inscription";
    }

    public String checkTransitionInscription(String inscription, boolean special, ShadowNet shadowNet) throws SyntaxException {
        throw new SyntaxException("Transition inscription is not allowed.");
    }

    public String checkPlaceInscription(String inscription, boolean special, ShadowNet shadowNet) throws SyntaxException {
        SinglePTNetCompiler.parseNumber(inscription);
        return "initialMarking";
    }

    private static int parseNumber(String inscr) throws SyntaxException {
        try {
            return Integer.parseInt(inscr.trim());
        }
        catch (NumberFormatException nfe) {
            throw new SyntaxException("Number expected", (Throwable)nfe).addObject((Object)inscr);
        }
    }

    protected static int parseNumericalInscription(ShadowInscribable inscribable, int defaultValue, int minValue) throws SyntaxException {
        int result = defaultValue;
        boolean inscriptionFound = false;
        for (Object elem : inscribable.elements()) {
            if (elem instanceof ShadowInscription) {
                if (inscriptionFound) {
                    throw new SyntaxException("Multiple inscriptions not supported").addObject((Object)inscribable);
                }
                inscriptionFound = true;
                result = SinglePTNetCompiler.parseNumber(((ShadowInscription)elem).getInscription());
                continue;
            }
            if (elem instanceof ShadowArc) continue;
            throw new SyntaxException("Unsupported inscription").addObject((Object)inscribable).addObject(elem);
        }
        if (result < minValue) {
            throw new SyntaxException("Inscribed value must not be lower than " + minValue).addObject((Object)inscribable);
        }
        return result;
    }

    @Override
    protected void compilePlaceInscriptions(ShadowPlace shadowPlace, Place place) throws SyntaxException {
        int marking = SinglePTNetCompiler.parseNumericalInscription((ShadowInscribable)shadowPlace, 0, 0);
        for (int i = 0; i < marking; ++i) {
            place.add((TokenSource)new ConstantTokenSource((Object)Tuple.NULL));
        }
    }

    @Override
    protected void compileArc(ShadowArc shadowArc) throws SyntaxException {
        int shadowArcType = shadowArc.getShadowArcType();
        if (shadowArcType != 1) {
            throw new SyntaxException("Unsupported arc type").addObject((Object)shadowArc);
        }
        Arc.Type arcType = shadowArc.isPlaceToTransition() ? Arc.Type.IN : Arc.Type.OUT;
        int multiplicity = SinglePTNetCompiler.parseNumericalInscription((ShadowInscribable)shadowArc, 1, 1);
        Transition transition = this.lookup.get(shadowArc.getTransition());
        Place place = this.lookup.get(shadowArc.getPlace());
        for (int i = 0; i < multiplicity; ++i) {
            Arc arc = new Arc(place, transition, arcType, (Expression)new ConstantExpression(null, (Object)Tuple.NULL), ConstantExpression.DOUBLE_ZERO_EXPRESSION);
            transition.add((TransitionInscription)arc);
        }
    }

    @Override
    protected Collection<TransitionInscription> compileTransitionInscription(ShadowInscription inscription) throws SyntaxException {
        throw new SyntaxException("Transitions may not carry inscriptions").addObject((Object)inscription);
    }

    @Override
    public void parseDeclarations(ShadowNet shadowNet) throws SyntaxException {
        Iterator iterator = shadowNet.elements().iterator();
        while (iterator.hasNext()) {
            Object elem = iterator.next();
            if (!(elem instanceof ShadowDeclarationNode)) continue;
            SyntaxException e = new SyntaxException("Declaration node is not allowed.");
            e.addObject(elem);
            while (iterator.hasNext()) {
                elem = iterator.next();
                if (!(elem instanceof ShadowDeclarationNode)) continue;
                e.addObject(elem);
            }
            throw e;
        }
    }
}

