/*
 * Decompiled with CFR 0.152.
 */
package de.renew.fa;

import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.DrawingTypeManager;
import CH.ifa.draw.framework.FilterContainer;
import de.renew.draw.storables.ontology.ConnectionFigure;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.fa.figures.FAStateFigure;
import de.renew.fa.figures.FAWordTextFigure;
import de.renew.gui.CPNDrawing;
import de.renew.gui.GraphLayout;
import de.renew.gui.LayoutableDrawing;
import de.renew.ioontology.ExtensionFileFilter;
import de.renew.simulator.api.SimulatorExtensions;
import de.renew.simulatorontology.shadow.ShadowCompilationResult;
import de.renew.simulatorontology.simulation.SimulationEnvironment;
import de.renew.simulatorontology.simulation.SimulatorExtension;
import java.awt.Color;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class FADrawing
extends CPNDrawing
implements LayoutableDrawing {
    static final long serialVersionUID = -4229673070089970973L;
    public static final Logger LOGGER = Logger.getLogger(FADrawing.class);
    private static FilterContainer _filterContainer;
    private FAWordTextFigure _word;
    private FAWordTextFigure _dataStructureTextFigure;

    public static FilterContainer getFilterContainer() {
        if (_filterContainer == null) {
            return new FilterContainer(DrawingTypeManager.getInstance().getFilter("de.renew.fa.FADrawing"));
        }
        return _filterContainer;
    }

    public FADrawing() {
        SimulatorExtensions.addExtension((SimulatorExtension)new SimulatorExtension(){

            public void simulationSetup(SimulationEnvironment env) {
                if (FADrawing.this._word != null) {
                    FADrawing.this._word.setColorForSimulation();
                }
            }

            public void netsCompiled(ShadowCompilationResult result) {
            }

            public void simulationTerminated() {
                FADrawing.this._dataStructureTextFigure = null;
                if (FADrawing.this._word != null) {
                    FADrawing.this._word.setNormalColor();
                }
            }

            public void simulationTerminating() {
                if (FADrawing.this._word != null) {
                    FADrawing.this._word.setNormalColor();
                }
            }
        });
    }

    public synchronized void fillInGraph(GraphLayout layout) {
        LOGGER.debug((Object)("fillInGraph(GraphLayout) called with " + String.valueOf(layout)));
        FigureEnumeration k = this.figures();
        while (k.hasMoreElements()) {
            Figure f = k.nextFigure();
            if (f instanceof FAStateFigure || f instanceof TextFigure && ((TextFigure)f).parent() == null) {
                layout.addNode(f);
            } else if (f instanceof ConnectionFigure) {
                layout.addEdge((ConnectionFigure)f, 20);
            }
            LOGGER.debug((Object)("added " + String.valueOf(f)));
        }
    }

    public String getDefaultExtension() {
        return this.getDefaultFileFilter().getExtension();
    }

    public ExtensionFileFilter getDefaultFileFilter() {
        return FADrawing.getFilterContainer().getDefaultFileFilter();
    }

    public HashSet<ExtensionFileFilter> getExportFileFilters() {
        return FADrawing.getFilterContainer().getExportFileFilters();
    }

    public HashSet<ExtensionFileFilter> getImportFileFilters() {
        return FADrawing.getFilterContainer().getImportFileFilters();
    }

    public String getWindowCategory() {
        return "Finite Automata";
    }

    public Figure add(Figure figure) {
        if (figure instanceof FAWordTextFigure) {
            FAWordTextFigure w;
            this._word = w = (FAWordTextFigure)figure;
        }
        return super.add(figure);
    }

    public void initializeDataStructureText() {
        this._dataStructureTextFigure = new FAWordTextFigure();
        this._dataStructureTextFigure.setReadOnly(true);
        this._dataStructureTextFigure.setTextColor(Color.BLACK);
        this._dataStructureTextFigure.setAttribute("FontSize", 20);
    }

    public FAWordTextFigure getDataStructureText() {
        return this._dataStructureTextFigure;
    }
}

