/*
 * Decompiled with CFR 0.152.
 */
package org.gitective.core.filter.commit;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.NB;

public class CommitImpact {
    private final int add;
    private final int edit;
    private final int delete;
    private final byte[] commit = new byte[20];

    public CommitImpact(AnyObjectId commit, int add, int edit, int delete) {
        commit.copyRawTo(this.commit, 0);
        this.add = add;
        this.edit = edit;
        this.delete = delete;
    }

    public int getAdd() {
        return this.add;
    }

    public int getEdit() {
        return this.edit;
    }

    public int getDelete() {
        return this.delete;
    }

    public ObjectId getCommit() {
        return ObjectId.fromRaw((byte[])this.commit);
    }

    public String toString() {
        return this.getCommit().name() + " +" + this.add + '/' + this.edit + "/-" + this.delete;
    }

    public int hashCode() {
        return this.getCommit().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CommitImpact)) {
            return false;
        }
        CommitImpact other = (CommitImpact)obj;
        return other.add == this.add && other.edit == this.edit && other.delete == this.delete && Arrays.equals(this.commit, other.commit);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DescendingImpactComparator
    implements Comparator<CommitImpact> {
        private int compare(CommitImpact o1, CommitImpact o2, int offset) {
            return NB.compareUInt32((int)NB.decodeInt32((byte[])o1.commit, (int)offset), (int)NB.decodeInt32((byte[])o2.commit, (int)offset));
        }

        @Override
        public int compare(CommitImpact o1, CommitImpact o2) {
            int diff = o2.add + o2.edit + o2.delete - (o1.add + o1.edit + o1.delete);
            if (diff != 0) {
                return diff;
            }
            diff = this.compare(o1, o2, 0);
            if (diff != 0) {
                return diff;
            }
            diff = this.compare(o1, o2, 4);
            if (diff != 0) {
                return diff;
            }
            diff = this.compare(o1, o2, 8);
            if (diff != 0) {
                return diff;
            }
            diff = this.compare(o1, o2, 12);
            if (diff != 0) {
                return diff;
            }
            return this.compare(o1, o2, 16);
        }
    }
}

