/*
 * Decompiled with CFR 0.152.
 */
package de.renew.export.io.exportFormats;

import CH.ifa.draw.util.ColorMap;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.exporting.AbstractDrawingExportFormat;
import de.renew.export.io.exportFormats.ExportPlugin;
import de.renew.io.api.FileApi;
import de.renew.ioontology.FileFilter;
import de.renew.ioontology.FileType;
import de.renew.plugin.PluginProperties;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.File;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.freehep.graphicsbase.util.UserProperties;
import org.freehep.graphicsio.AbstractVectorGraphicsIO;
import org.freehep.graphicsio.ps.AbstractPSGraphics2D;
import org.freehep.graphicsio.ps.EPSGraphics2D;

public class EPSExportFormat
extends AbstractDrawingExportFormat {
    public static final Logger LOGGER = Logger.getLogger(EPSExportFormat.class);
    public static final String EPS_EXPORT_HOTKEY_PROP_NAME = "de.renew.hotkeymap.export.exportcurrentdrawingeps";
    private PluginProperties _plugincfg;

    public EPSExportFormat() {
        super("EPS", (FileFilter)FileApi.createExtensionFileFilter((FileType)FileType.EPS));
    }

    public EPSExportFormat(String formatName) {
        super(formatName, (FileFilter)FileApi.createExtensionFileFilter((FileType)FileType.EPS));
    }

    public EPSExportFormat(PluginProperties plugincfg) {
        super("EPS", (FileFilter)FileApi.createExtensionFileFilter((FileType)FileType.EPS));
        this._plugincfg = plugincfg;
    }

    public boolean canExportNto1() {
        return false;
    }

    public File export(Drawing[] drawings, File path) throws Exception {
        File result = null;
        assert (result != null) : "Failure in EPSExportFormat: result == null";
        return result;
    }

    public File export(Drawing drawing, File file) throws Exception {
        Rectangle bounds = drawing.getBounds();
        return this.internalExport(drawing, file, bounds, true);
    }

    public File internalExport(Drawing drawing, File path, Rectangle bounds, boolean removeWhiteSpace) throws Exception {
        File result = null;
        int x = bounds.x;
        int y = bounds.y;
        int width = bounds.width;
        int height = bounds.height;
        Dimension d = new Dimension(width, height);
        EPSGraphics2D graphics = new EPSGraphics2D(path, d);
        UserProperties defaultProperties = new UserProperties();
        defaultProperties.setProperty(EPSGraphics2D.PAGE_MARGINS, new Insets(0, 0, 0, 0));
        defaultProperties.setProperty(EPSGraphics2D.FIT_TO_PAGE, true);
        String fontHandling = "shapes";
        ExportPlugin exportPlugin = ExportPlugin.getCurrent();
        if (exportPlugin != null) {
            fontHandling = exportPlugin.getEpsFontHandling();
        }
        if ("embed".equals(fontHandling)) {
            defaultProperties.setProperty(AbstractPSGraphics2D.EMBED_FONTS, true);
            defaultProperties.setProperty(AbstractVectorGraphicsIO.TEXT_AS_SHAPES, false);
        } else if ("none".equals(fontHandling)) {
            defaultProperties.setProperty(AbstractPSGraphics2D.EMBED_FONTS, false);
            defaultProperties.setProperty(AbstractVectorGraphicsIO.TEXT_AS_SHAPES, false);
        } else {
            if (!"shapes".equals(fontHandling)) {
                LOGGER.warn((Object)("Unknown EPS font handling configured: " + fontHandling));
            }
            defaultProperties.setProperty(AbstractPSGraphics2D.EMBED_FONTS, false);
            defaultProperties.setProperty(AbstractVectorGraphicsIO.TEXT_AS_SHAPES, true);
        }
        defaultProperties.setProperty(AbstractPSGraphics2D.CLIP, true);
        defaultProperties.setProperty(AbstractPSGraphics2D.PAGE_SIZE, AbstractPSGraphics2D.CUSTOM_PAGE_SIZE);
        defaultProperties.setProperty(AbstractPSGraphics2D.CUSTOM_PAGE_SIZE, d);
        defaultProperties.setProperty(AbstractPSGraphics2D.BACKGROUND, false);
        defaultProperties.setProperty(AbstractPSGraphics2D.BACKGROUND_COLOR, ColorMap.NONE);
        graphics.setProperties((Properties)defaultProperties);
        graphics.startExport();
        if (removeWhiteSpace) {
            graphics.translate(x * -1, y * -1);
        }
        graphics.clipRect(x, y, width, height);
        drawing.draw((Graphics)graphics);
        graphics.endExport();
        result = path;
        assert (result != null) : "Failure in EPSExportFormat: result == null";
        return result;
    }

    public boolean canExportDrawing(Drawing drawing) {
        boolean result = false;
        result = true;
        return result;
    }

    public int getShortCut() {
        if (this._plugincfg != null) {
            return PluginProperties.getUserProperties().getHotkeyProperty(EPS_EXPORT_HOTKEY_PROP_NAME, this._plugincfg.getHotkeyProperty(EPS_EXPORT_HOTKEY_PROP_NAME)).getKeyCode();
        }
        return PluginProperties.getUserProperties().getHotkeyProperty(EPS_EXPORT_HOTKEY_PROP_NAME).getKeyCode();
    }

    public int getModifier() {
        if (this._plugincfg != null) {
            return PluginProperties.getUserProperties().getHotkeyProperty(EPS_EXPORT_HOTKEY_PROP_NAME, this._plugincfg.getHotkeyProperty(EPS_EXPORT_HOTKEY_PROP_NAME)).getModifiers();
        }
        return PluginProperties.getUserProperties().getHotkeyProperty(EPS_EXPORT_HOTKEY_PROP_NAME).getModifiers();
    }
}

