/*
 * Decompiled with CFR 0.152.
 */
package de.renew.simulator.api;

import de.renew.plugin.ServiceLookupException;
import de.renew.plugin.ServiceLookupInfrastructure;
import de.renew.simulator.api.ISimulatorExtensions;
import de.renew.simulatorontology.simulation.SimulatorExtension;
import org.apache.log4j.Logger;

public final class SimulatorExtensions {
    private static final ISimulatorExtensions SIMULATOR_EXTENSIONS;
    private static final Logger LOGGER;

    private SimulatorExtensions() {
    }

    public static void addExtension(SimulatorExtension extension) {
        SIMULATOR_EXTENSIONS.addExtension(extension);
    }

    public static void removeExtension(SimulatorExtension extension) {
        SIMULATOR_EXTENSIONS.removeExtension(extension);
    }

    static {
        LOGGER = Logger.getLogger(SimulatorExtensions.class);
        try {
            SIMULATOR_EXTENSIONS = (ISimulatorExtensions)ServiceLookupInfrastructure.getInstance().getFirstServiceProvider(ISimulatorExtensions.class);
        }
        catch (ServiceLookupException e) {
            LOGGER.error((Object)("Could not find a service provider for " + String.valueOf(ISimulatorExtensions.class) + ": "), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

