/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.application;

import CH.ifa.draw.application.DrawApplication;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.Logger;

class DrawingLoadServer
extends Thread {
    public static Logger logger = Logger.getLogger(DrawingLoadServer.class);
    private final DrawApplication editor;
    private ServerSocket s = null;

    public DrawingLoadServer(DrawApplication editor, int port) throws IOException {
        this.editor = editor;
        logger.debug((Object)("Drawing Load Server setting up server socket at port " + port + " on loopback interface..."));
        this.s = new ServerSocket(port, 50, InetAddress.getByName(null));
        logger.debug((Object)("Drawing Load Server bound to: " + String.valueOf(this.s)));
    }

    @Override
    public void run() {
        logger.debug((Object)"Drawing Load Server waiting for parameters...");
        while (true) {
            Socket client = null;
            try {
                client = this.s.accept();
                logger.debug((Object)"Parameter server accepted client.");
                BufferedReader in = new BufferedReader(new InputStreamReader(client.getInputStream()));
                try {
                    String drawingFileName;
                    do {
                        if ((drawingFileName = in.readLine()) == null) continue;
                        logger.debug((Object)("Received Parameter " + drawingFileName));
                        this.editor.loadAndOpenCommandLineDrawings(new String[]{drawingFileName});
                    } while (drawingFileName != null);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                logger.debug((Object)"Connection closed.");
                in.close();
                client.close();
                continue;
            }
            catch (Exception e) {
                logger.error((Object)("Drawing Load Server threw exception: " + String.valueOf(e)));
                continue;
            }
            break;
        }
    }
}

