/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.figures;

import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.figures.PolyLineSegmentLocator;
import CH.ifa.draw.standard.LocatorHandle;
import CH.ifa.draw.util.Geom;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.ui.ontology.DrawingView;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;

@Deprecated
public class ElbowHandle
extends LocatorHandle {
    private final int _segment;
    private int _lastX;
    private int _lastY;

    @Deprecated
    public ElbowHandle(LineConnection owner, int segment) {
        super(owner, new PolyLineSegmentLocator(segment));
        this._segment = segment;
    }

    @Override
    public void invokeStart(int x, int y, DrawingView view) {
        super.invokeStart(x, y, view);
        this._lastX = x;
        this._lastY = y;
    }

    @Override
    public void invokeStep(int x, int y, int anchorX, int anchorY, DrawingView view) {
        Point np2;
        Point np1;
        LineConnection line = this.ownerConnection();
        Point p1 = line.pointAt(this._segment);
        Point p2 = line.pointAt(this._segment + 1);
        int ddx = x - this._lastX;
        int ddy = y - this._lastY;
        if (this.isVertical(p1, p2)) {
            int cx = this.constrainX(p1.x + ddx);
            np1 = new Point(cx, p1.y);
            np2 = new Point(cx, p2.y);
        } else {
            int cy = this.constrainY(p1.y + ddy);
            np1 = new Point(p1.x, cy);
            np2 = new Point(p2.x, cy);
        }
        line.setPointAt(np1, this._segment);
        line.setPointAt(np2, this._segment + 1);
        this._lastX = x;
        this._lastY = y;
    }

    private boolean isVertical(Point p1, Point p2) {
        return p1.x == p2.x;
    }

    @Override
    public void draw(Graphics g) {
        Rectangle r = this.displayBox();
        g.setColor(Color.yellow);
        g.fillOval(r.x, r.y, r.width, r.height);
        g.setColor(Color.black);
        g.drawOval(r.x, r.y, r.width, r.height);
    }

    private int constrainX(int x) {
        LineConnection line = this.ownerConnection();
        Figure startFigure = line.start().owner();
        Figure endFigure = line.end().owner();
        Rectangle start = startFigure.displayBox();
        Rectangle end = endFigure.displayBox();
        Insets i1 = startFigure.connectionInsets();
        Insets i2 = endFigure.connectionInsets();
        int r1x = start.x + i1.left;
        int r1width = start.width - i1.left - i1.right - 1;
        int r2x = end.x + i2.left;
        int r2width = end.width - i2.left - i2.right - 1;
        if (this._segment == 0) {
            x = Geom.range(r1x, r1x + r1width, x);
        }
        if (this._segment == line.pointCount() - 2) {
            x = Geom.range(r2x, r2x + r2width, x);
        }
        return x;
    }

    private int constrainY(int y) {
        LineConnection line = this.ownerConnection();
        Figure startFigure = line.start().owner();
        Figure endFigure = line.end().owner();
        Rectangle start = startFigure.displayBox();
        Rectangle end = endFigure.displayBox();
        Insets i1 = startFigure.connectionInsets();
        Insets i2 = endFigure.connectionInsets();
        int r1y = start.y + i1.top;
        int r1height = start.height - i1.top - i1.bottom - 1;
        int r2y = end.y + i2.top;
        int r2height = end.height - i2.top - i2.bottom - 1;
        if (this._segment == 0) {
            y = Geom.range(r1y, r1y + r1height, y);
        }
        if (this._segment == line.pointCount() - 2) {
            y = Geom.range(r2y, r2y + r2height, y);
        }
        return y;
    }

    private LineConnection ownerConnection() {
        return (LineConnection)this.owner();
    }
}

