/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.standard.ChangeAttributeCommand;
import CH.ifa.draw.standard.ChooseAttributeCommand;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.ui.ontology.DrawingView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionListener;

@Deprecated(since="5.0", forRemoval=true)
public class ChooseFontCommand
extends ChooseAttributeCommand {
    private JList<String> _fontList;
    private JList<Object> _sizeList;
    private JCheckBox _cbBold;
    private JCheckBox _cbItalic;
    private JTextArea _txtSample;
    private static final int[] SIZES = new int[]{2, 4, 6, 8, 10, 12, 14, 16, 18, 20, 22, 24, 30, 36, 48, 72};
    private SizeListModel _sizeModel;

    public ChooseFontCommand(String displayName, String name, String attributeName, Class<?> type) {
        super(displayName, name, attributeName, type);
    }

    @Override
    protected void specializeDialog() {
        this._fontList = new JList<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(150, 144);
            }
        };
        this._fontList.setSelectionMode(0);
        this._sizeModel = new SizeListModel(SIZES);
        this._sizeList = new JList<Object>((ListModel)this._sizeModel){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(25, 144);
            }
        };
        this._sizeList.setSelectionMode(0);
        this._cbBold = new JCheckBox("Bold");
        this._cbItalic = new JCheckBox("Italic");
        this._txtSample = new JTextArea(){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                return new Dimension(385, 80);
            }
        };
        this._txtSample.setText("This is a sample text.");
        this.setFont(null);
        ListSelectionListener listListener = e -> this._txtSample.setFont(this.getCurrentFont());
        this._fontList.addListSelectionListener(listListener);
        this._sizeList.addListSelectionListener(listListener);
        ActionListener cbListener = e -> this._txtSample.setFont(this.getCurrentFont());
        this._cbBold.addActionListener(cbListener);
        this._cbItalic.addActionListener(cbListener);
        JPanel fontChoosePanel = new JPanel();
        fontChoosePanel.setLayout(new BorderLayout());
        JPanel leftPanel = new JPanel();
        leftPanel.setLayout(new BorderLayout());
        leftPanel.add((Component)new JScrollPane(this._fontList), "Center");
        leftPanel.add((Component)new JScrollPane(this._sizeList), "East");
        fontChoosePanel.add((Component)leftPanel, "Center");
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new FlowLayout());
        rightPanel.add(this._cbBold);
        rightPanel.add(this._cbItalic);
        fontChoosePanel.add((Component)rightPanel, "East");
        fontChoosePanel.add((Component)new JScrollPane(this._txtSample), "South");
        this.dialog.getContentPane().add((Component)fontChoosePanel, "Center");
        this.dialog.setSize(200, 200);
        this.dialog.setResizable(true);
        this.dialog.pack();
    }

    private void setFont(Font font) {
        if (font == null) {
            font = this._txtSample.getFont();
        }
        this._fontList.setSelectedValue(font.getName(), true);
        this._fontList.ensureIndexIsVisible(this._fontList.getSelectedIndex());
        Integer sizeInt = font.getSize();
        this._sizeList.setSelectedValue(sizeInt, true);
        if (!sizeInt.equals(this._sizeList.getSelectedValue())) {
            this._sizeModel.addSize(sizeInt);
            this._sizeList.setSelectedValue(sizeInt, true);
        }
        this._sizeList.ensureIndexIsVisible(this._sizeList.getSelectedIndex());
        this._cbBold.setSelected(font.isBold());
        this._cbItalic.setSelected(font.isItalic());
        this._txtSample.setFont(font);
    }

    private Font getCurrentFont() {
        String fontFamily = this._fontList.getSelectedValue();
        int fontSize = (Integer)this._sizeList.getSelectedValue();
        int fontType = 0;
        if (this._cbBold.isSelected()) {
            ++fontType;
        }
        if (this._cbItalic.isSelected()) {
            fontType += 2;
        }
        return new Font(fontFamily, fontType, fontSize);
    }

    @Override
    protected void updateFromFigure() {
        DrawingView view = this.getEditor().view();
        Font font = null;
        FigureEnumeration k = view.selectionElements();
        while (k.hasMoreElements() && font == null) {
            Figure f = k.nextFigure();
            Object name = f.getAttribute("FontName");
            Object style = f.getAttribute("FontStyle");
            Object size = f.getAttribute("FontSize");
            if (name == null || style == null || size == null) continue;
            font = new Font((String)name, (int)((Integer)style), (Integer)size);
        }
        this.setFont(font);
    }

    @Override
    protected void apply() {
        String fontFamily = this._fontList.getSelectedValue();
        Integer fontSize = (Integer)this._sizeList.getSelectedValue();
        int fontType = 0;
        if (this._cbBold.isSelected()) {
            ++fontType;
        }
        if (this._cbItalic.isSelected()) {
            fontType += 2;
        }
        new ChangeAttributeCommand("", "FontName", fontFamily).execute();
        new ChangeAttributeCommand("", "FontSize", fontSize).execute();
        new ChangeAttributeCommand("", "FontStyle", fontType).execute();
    }

    private static class SizeListModel
    implements ListModel<Object> {
        private final List<Integer> _sizeList;
        private final List<ListDataListener> _listeners;

        public SizeListModel(int[] sizes) {
            this._sizeList = new ArrayList<Integer>(sizes.length * 2);
            for (int size : sizes) {
                this._sizeList.add(size);
            }
            Collections.sort(this._sizeList);
            this._listeners = new ArrayList<ListDataListener>();
        }

        @Override
        public Object getElementAt(int index) {
            return this._sizeList.get(index);
        }

        @Override
        public int getSize() {
            return this._sizeList.size();
        }

        @Override
        public void addListDataListener(ListDataListener listener) {
            this._listeners.add(listener);
        }

        @Override
        public void removeListDataListener(ListDataListener listener) {
            this._listeners.remove(listener);
        }

        public void addSize(Integer size) {
            assert (size != null);
            assert (this._sizeList != null);
            int index = Collections.binarySearch(this._sizeList, size);
            if (index <= 0) {
                int indexToInsert = -index - 1;
                this._sizeList.add(indexToInsert, size);
                ListDataEvent event = new ListDataEvent(this, 1, indexToInsert, indexToInsert);
                for (ListDataListener listener : this._listeners) {
                    listener.intervalAdded(event);
                }
            }
            assert (this._sizeList.contains(size));
        }
    }
}

