/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.standard.LocatorHandle;
import CH.ifa.draw.util.Geom;
import de.renew.draw.storables.ontology.ConnectionFigure;
import de.renew.draw.storables.ontology.Connector;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.storables.ontology.Locator;
import de.renew.draw.ui.ontology.DrawingView;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

public class ConnectionHandle
extends LocatorHandle {
    private ConnectionFigure _connection;
    private final ConnectionFigure _prototype;
    private Figure _target = null;

    public ConnectionHandle(Figure owner, Locator l, ConnectionFigure prototype) {
        super(owner, l);
        this._prototype = prototype;
    }

    @Override
    public void invokeStart(int x, int y, DrawingView view) {
        super.invokeStart(x, y, view);
        this._connection = this.createConnection();
        Point p = this.locate();
        this._connection.startPoint(p.x, p.y);
        this._connection.endPoint(p.x, p.y);
        view.drawing().add(this._connection);
    }

    protected ConnectionFigure getConnection() {
        return this._connection;
    }

    @Override
    public void invokeStep(MouseEvent e, int x, int y, int anchorX, int anchorY, DrawingView view) {
        Connector target;
        Point p = new Point(x, y);
        Figure f = null;
        List<Figure> figures = this.findAllConnectableFigures(x, y, view.drawing());
        for (Figure fig : figures) {
            if (fig == null || !fig.canConnect() || fig.includes(this.owner()) || !this._connection.canConnect(this.owner(), fig)) continue;
            f = fig;
            break;
        }
        if (f != this._target) {
            if (this._target != null) {
                this._target.connectorVisibility(false);
            }
            this._target = f;
            if (this._target != null) {
                this._target.connectorVisibility(true);
            }
        }
        if ((target = this.findConnectionTarget(p.x, p.y, view.drawing())) != null) {
            p = Geom.center(target.displayBox());
        } else if (e.isControlDown()) {
            p = this.snap(p.x, p.y);
        }
        this._connection.endPoint(p.x, p.y);
    }

    protected Point snap(int x, int y) {
        return new Point(x, y);
    }

    protected void handleConnect(Figure start, Figure end) {
    }

    @Override
    public void invokeEnd(int x, int y, int anchorX, int anchorY, DrawingView view) {
        Connector target = this.findConnectionTarget(x, y, view.drawing());
        if (target != null) {
            this._connection.connectStart(this.startConnector());
            this._connection.connectEnd(target);
            this._connection.updateConnection();
            this.handleConnect(this.startConnector().owner(), target.owner());
            target.owner().changed();
            view.clearSelection();
            view.addToSelection(target.owner());
        } else {
            view.drawing().remove(this._connection);
            this.noChangesMade();
        }
        this._connection = null;
        if (this._target != null) {
            this._target.connectorVisibility(false);
            this._target = null;
        }
        super.invokeEnd(x, y, anchorX, anchorY, view);
    }

    @Override
    public void abort(DrawingView view) {
        view.drawing().remove(this._connection);
        this.noChangesMade();
        this._connection = null;
    }

    protected Connector startConnector() {
        Point p = this.locate();
        return this.owner().connectorAt(p.x, p.y);
    }

    protected ConnectionFigure createConnection() {
        return (ConnectionFigure)this._prototype.clone();
    }

    protected Connector findConnectionTarget(int x, int y, Drawing drawing) {
        List<Figure> possibleTargets = this.findAllConnectableFigures(x, y, drawing);
        for (Figure target : possibleTargets) {
            if (target == null || !target.canConnect() || target.includes(this.owner()) || !this._connection.canConnect(this.owner(), target)) continue;
            return this.findConnector(x, y, target);
        }
        return null;
    }

    protected Figure findConnectableFigure(int x, int y, Drawing drawing) {
        FigureEnumeration k = drawing.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            if (figure.includes(this._connection) || !figure.canConnect() || !figure.containsPoint(x, y)) continue;
            return figure;
        }
        return null;
    }

    protected List<Figure> findAllConnectableFigures(int x, int y, Drawing drawing) {
        ArrayList<Figure> connectableFigures = new ArrayList<Figure>();
        FigureEnumeration k = drawing.figuresReverse();
        while (k.hasMoreElements()) {
            Figure figure = k.nextFigure();
            if (figure.includes(this._connection) || !figure.canConnect() || !figure.containsPoint(x, y)) continue;
            connectableFigures.add(figure);
        }
        return connectableFigures;
    }

    protected Connector findConnector(int x, int y, Figure f) {
        return f.connectorAt(x, y);
    }

    @Override
    public void draw(Graphics g) {
        Rectangle r = this.displayBox();
        g.setColor(Color.blue);
        g.drawOval(r.x, r.y, r.width, r.height);
    }
}

