/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.figures.AttributeFigure;
import CH.ifa.draw.util.ColorMap;
import java.awt.Color;
import java.awt.GridLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

@Deprecated(since="5.0", forRemoval=true)
public class InitialAttributesMenu
extends JPanel {
    final AttributeFigure _prototype;
    final Color _originalFillColor;
    final Color _originalPenColor;
    final Color _originalTextColor;
    final Integer _originalArrow;
    final String _originalLineStyle;
    final Integer _originalLineWidth;

    public InitialAttributesMenu(AttributeFigure prototype) {
        this._prototype = prototype;
        this._originalFillColor = prototype.getFillColor();
        this._originalPenColor = prototype.getFrameColor();
        this._originalTextColor = (Color)prototype.getAttribute("TextColor");
        this._originalArrow = (Integer)prototype.getAttribute("ArrowMode");
        this._originalLineStyle = (String)prototype.getAttribute("LineStyle");
        this._originalLineWidth = (Integer)prototype.getAttribute("LineWidth");
        this.add(this.createMenu());
        JButton resetButton = new JButton("Reset");
        resetButton.addActionListener(e -> {
            this._prototype.setAttribute("FillColor", this._originalFillColor);
            this._prototype.setAttribute("FrameColor", this._originalPenColor);
            this._prototype.setAttribute("TextColor", this._originalTextColor);
            this._prototype.setAttribute("ArrowMode", this._originalArrow);
            this._prototype.setAttribute("LineStyle", this._originalLineStyle);
            this._prototype.setAttribute("LineWidth", this._originalLineWidth);
        });
        this.add(resetButton);
    }

    public JPanel createMenu() {
        JPanel options = new JPanel();
        options.setLayout(new GridLayout(3, 2));
        options.add(this.createColorMenu("Fill Color", "FillColor"));
        options.add(this.createColorMenu("Pen Color", "FrameColor"));
        options.add(this.createColorMenu("Text Color", "TextColor"));
        options.add(this.createArrowMenu());
        options.add(this.createLineStyleMenu());
        options.add(this.createLineWidthMenu());
        return options;
    }

    private JPanel createLineWidthMenu() {
        JPanel lineWidthPanel = new JPanel();
        lineWidthPanel.add(new JLabel("Line Width"));
        Integer[] lineWidthList = new Integer[10];
        for (int i = 0; i < 10; ++i) {
            lineWidthList[i] = i + 1;
        }
        JComboBox<Integer> comboBox = new JComboBox<Integer>(lineWidthList);
        comboBox.addActionListener(e -> {
            Object patt2879$temp = comboBox.getSelectedItem();
            if (patt2879$temp instanceof Integer) {
                Integer width = (Integer)patt2879$temp;
                this._prototype.setAttribute("LineWidth", width);
            }
        });
        lineWidthPanel.add(comboBox);
        return lineWidthPanel;
    }

    private JPanel createLineStyleMenu() {
        JPanel lineStylePanel = new JPanel();
        lineStylePanel.add(new JLabel("Line Style"));
        String[] lineStyleList = new String[]{"Normal", "Dotted", "Dashed", "Medium Dashed", "Long Dashed", "Dash-Dotted"};
        JComboBox<String> comboBox = new JComboBox<String>(lineStyleList);
        comboBox.addActionListener(e -> {
            Object patt3520$temp = comboBox.getSelectedItem();
            if (patt3520$temp instanceof String) {
                String lineStyle;
                switch (lineStyle = (String)patt3520$temp) {
                    case "Normal": {
                        this._prototype.setAttribute("LineStyle", "");
                        break;
                    }
                    case "Dotted": {
                        this._prototype.setAttribute("LineStyle", "1 2");
                        break;
                    }
                    case "Dashed": {
                        this._prototype.setAttribute("LineStyle", "10");
                        break;
                    }
                    case "Medium Dashed": {
                        this._prototype.setAttribute("LineStyle", "15 10");
                        break;
                    }
                    case "Long Dashed": {
                        this._prototype.setAttribute("LineStyle", "20");
                        break;
                    }
                    case "Dash-Dotted": {
                        this._prototype.setAttribute("LineStyle", "7 3 1 3");
                    }
                }
            }
        });
        lineStylePanel.add(comboBox);
        return lineStylePanel;
    }

    private JPanel createColorMenu(String name, String attribute) {
        JPanel colorPanel = new JPanel();
        colorPanel.add(new JLabel(name));
        int size = ColorMap.size();
        ColorComboBoxItem[] colorList = new ColorComboBoxItem[size];
        for (int i = 0; i < size; ++i) {
            colorList[i] = new ColorComboBoxItem(ColorMap.color(i), ColorMap.name(i));
        }
        JComboBox<ColorComboBoxItem> comboBox = new JComboBox<ColorComboBoxItem>(colorList);
        comboBox.addActionListener(e -> {
            Object patt5380$temp = comboBox.getSelectedItem();
            if (patt5380$temp instanceof ColorComboBoxItem) {
                ColorComboBoxItem item = (ColorComboBoxItem)patt5380$temp;
                this._prototype.setAttribute(attribute, item.getColor());
            }
        });
        colorPanel.add(comboBox);
        return colorPanel;
    }

    private JPanel createArrowMenu() {
        JPanel arrowPanel = new JPanel();
        arrowPanel.add(new JLabel("Arrow Style"));
        String[] arrowList = new String[]{"No Arrow", "Start", "End", "Start/End"};
        JComboBox<String> comboBox = new JComboBox<String>(arrowList);
        comboBox.addActionListener(e -> {
            Object patt5944$temp = comboBox.getSelectedItem();
            if (patt5944$temp instanceof String) {
                String arrow;
                switch (arrow = (String)patt5944$temp) {
                    case "No Arrow": {
                        this._prototype.setAttribute("ArrowMode", 0);
                        break;
                    }
                    case "Start": {
                        this._prototype.setAttribute("ArrowMode", 1);
                        break;
                    }
                    case "End": {
                        this._prototype.setAttribute("ArrowMode", 2);
                        break;
                    }
                    case "Start/End": {
                        this._prototype.setAttribute("ArrowMode", 3);
                    }
                }
            }
        });
        arrowPanel.add(comboBox);
        return arrowPanel;
    }

    private static class ColorComboBoxItem {
        final Color _color;
        final String _name;

        public ColorComboBoxItem(Color color, String name) {
            this._color = color;
            this._name = name;
        }

        public String toString() {
            return this._name;
        }

        public Color getColor() {
            return this._color;
        }
    }
}

