/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.application.AbstractFileDragDropListener;
import CH.ifa.draw.figures.CompositeAttributeFigure;
import CH.ifa.draw.figures.ImageFigure;
import CH.ifa.draw.figures.ImageFigureCreationTool;
import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.FigureSelection;
import CH.ifa.draw.standard.DeleteCommand;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.standard.NullDrawing;
import CH.ifa.draw.standard.SimpleUpdateStrategy;
import CH.ifa.draw.util.ContextGraphics;
import CH.ifa.draw.util.Geom;
import bibliothek.gui.DockUI;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.DrawingChangeEvent;
import de.renew.draw.storables.ontology.DrawingChangeListener;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureChangeEvent;
import de.renew.draw.storables.ontology.FigureChangeListener;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.storables.ontology.FigureWithDependencies;
import de.renew.draw.ui.ontology.AbstractCommand;
import de.renew.draw.ui.ontology.DrawingEditor;
import de.renew.draw.ui.ontology.DrawingView;
import de.renew.draw.ui.ontology.FigureHandle;
import de.renew.draw.ui.ontology.Painter;
import de.renew.draw.ui.ontology.PointConstrainer;
import de.renew.draw.ui.ontology.Tool;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.print.PageFormat;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.apache.log4j.Logger;

public class StandardDrawingView
extends JPanel
implements DrawingView,
FigureChangeListener,
MouseListener,
MouseWheelListener,
MouseMotionListener,
KeyListener {
    private static final long serialVersionUID = -3878153366174603336L;
    private final int _drawingViewSerializedDataVersion = 1;
    private static final Logger LOGGER = Logger.getLogger(StandardDrawingView.class);
    private transient DrawingEditor _editor;
    private Drawing _drawing;
    private transient Rectangle _damage = null;
    private transient Vector<Figure> _selection;
    private transient Vector<FigureHandle> _selectionHandles;
    private transient Object _selectionHandlesLock = new Object();
    private final Dimension _viewSize;
    private Point _lastClick;
    private Vector<Painter> _backgrounds = null;
    private Vector<Painter> _foregrounds = null;
    private Painter _updateStrategy;
    private PointConstrainer _constrainer;
    private transient Object _repaintLock = new Object();
    private double _scaleFactor = 1.0;
    private final double _maxScaling = 3.0;
    private final double _minScaling = 0.2;
    private AffineTransform _affinetransform;

    public StandardDrawingView(DrawingEditor editor, int width, int height) {
        this._editor = editor;
        this._viewSize = new Dimension(width, height);
        this._lastClick = new Point(0, 0);
        this._constrainer = null;
        this._selection = new Vector();
        this.setDisplayUpdate(new SimpleUpdateStrategy());
        this.setBackground(Color.lightGray);
        this.setOpaque(true);
        this.setLayout(null);
        this._affinetransform = AffineTransform.getScaleInstance(1.0, 1.0);
        AbstractFileDragDropListener dragDropListener = new AbstractFileDragDropListener(){

            @Override
            protected void handleFilesDrawing(File[] files, Point loc) {
                for (File file : files) {
                    if (file.isDirectory()) continue;
                    StandardDrawingView.this._editor.openOrLoadDrawing(file, StandardDrawingView.this);
                }
            }

            @Override
            protected void handleFilesImage(File[] files, Point loc) {
                if (files.length >= 1) {
                    Vector<Figure> imagesToAdd = new Vector<Figure>();
                    for (File file : files) {
                        Image image = ImageFigureCreationTool.createImage(file.getAbsolutePath(), StandardDrawingView.this);
                        Point p = StandardDrawingView.this.constrainPoint(new Point(loc.x, loc.y));
                        StandardDrawingView.this.inverseTransformPoint(p);
                        ImageFigure imageFigure = new ImageFigure(image, file.getAbsolutePath(), p);
                        Rectangle displayBox = imageFigure.displayBox();
                        imageFigure.moveBy(-(displayBox.width / 2), -(displayBox.height / 2));
                        imagesToAdd.add(imageFigure);
                    }
                    StandardDrawingView.this.addAll(imagesToAdd);
                    StandardDrawingView.this.checkDamage();
                }
            }
        };
        new DropTarget(this, dragDropListener);
    }

    @Deprecated
    public void setEditor(DrawingEditor editor) {
        this._editor = editor;
    }

    public Tool tool() {
        return this._editor.tool();
    }

    @Override
    public Drawing drawing() {
        return this._drawing;
    }

    @Override
    public void setDrawing(Drawing d) {
        if (this._drawing != null) {
            this.clearSelection();
            this._drawing.removeDrawingChangeListener(this);
        }
        this._drawing = d;
        this._drawing.addDrawingChangeListener(this);
        this.checkMinimumSize(null);
        this.repaint();
    }

    public void setNullDrawing() {
        this.setDrawing(NullDrawing.INSTANCE);
    }

    @Override
    public DrawingEditor editor() {
        return this._editor;
    }

    @Override
    public Figure add(Figure figure) {
        return this.drawing().add(figure);
    }

    @Override
    public Figure remove(Figure figure) {
        return this.drawing().remove(figure);
    }

    @Override
    public void addAll(Vector<Figure> figures) {
        FigureEnumerator k = new FigureEnumerator(figures);
        while (k.hasMoreElements()) {
            this.add(k.nextFigure());
        }
    }

    public void removeAll(Vector<Figure> figures) {
        FigureEnumerator k = new FigureEnumerator((Vector)figures.clone());
        while (k.hasMoreElements()) {
            this.remove(k.nextFigure());
        }
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension result = this._viewSize;
        if (this._scaleFactor > 1.0 && this._affinetransform != null) {
            Rectangle r = this._affinetransform.createTransformedShape(new Rectangle(this._viewSize.width, this._viewSize.height)).getBounds();
            result = r.getSize();
        }
        return result;
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Deprecated
    public void setDisplayUpdate(Painter updateStrategy) {
        this._updateStrategy = updateStrategy;
    }

    @Override
    public Vector<Figure> selection() {
        return new Vector<Figure>(this._selection);
    }

    @Override
    public FigureEnumeration selectionElements() {
        return new FigureEnumerator(this.selection());
    }

    public Vector<Figure> inZOrder(Vector<Figure> selection) {
        Vector<Figure> result = new Vector<Figure>(selection.size());
        FigureEnumeration figures = this.drawing().figures();
        while (figures.hasMoreElements()) {
            Figure f = figures.nextFigure();
            if (!selection.contains(f)) continue;
            result.addElement(f);
        }
        return result;
    }

    @Override
    public Vector<Figure> selectionZOrdered() {
        return this.inZOrder(this._selection);
    }

    @Override
    public int selectionCount() {
        return this._selection.size();
    }

    @Override
    public void addToSelection(Figure figure) {
        if (this.addToSelectionInternal(figure)) {
            this.selectionChanged();
        }
    }

    protected boolean addToSelectionInternal(Figure figure) {
        if (!this._selection.contains(figure) && figure.isSelectable()) {
            this._selection.addElement(figure);
            figure.addFigureChangeListener(this);
            this.selectionInvalidateHandles();
            figure.invalidate();
            return true;
        }
        return false;
    }

    @Override
    public void addToSelectionAll(Vector<Figure> figures) {
        this.addToSelectionAll(new FigureEnumerator(figures));
    }

    @Override
    public void addToSelectionAll(FigureEnumeration figures) {
        boolean changed = false;
        while (figures.hasMoreElements()) {
            changed |= this.addToSelectionInternal(figures.nextFigure());
        }
        if (changed) {
            this.selectionChanged();
        }
    }

    @Deprecated
    public void removeFromSelection(Figure figure) {
        if (this.removeFromSelectionInternal(figure)) {
            this.selectionChanged();
        }
    }

    protected boolean removeFromSelectionInternal(Figure figure) {
        if (this._selection.contains(figure)) {
            this._selection.removeElement(figure);
            figure.removeFigureChangeListener(this);
            this.selectionInvalidateHandles();
            figure.invalidate();
            return true;
        }
        return false;
    }

    @Override
    public void removeFromSelectionAll(Vector<Figure> figures) {
        this.removeFromSelectionAll(new FigureEnumerator(figures));
    }

    @Deprecated
    public void removeFromSelectionAll(FigureEnumeration figures) {
        boolean changed = false;
        while (figures.hasMoreElements()) {
            changed |= this.removeFromSelectionInternal(figures.nextFigure());
        }
        if (changed) {
            this.selectionChanged();
        }
    }

    @Override
    public void toggleSelection(Figure figure) {
        if (this.toggleSelectionInternal(figure)) {
            this.selectionChanged();
        }
    }

    @Deprecated
    public boolean toggleSelectionInternal(Figure figure) {
        if (this._selection.contains(figure)) {
            return this.removeFromSelectionInternal(figure);
        }
        return this.addToSelectionInternal(figure);
    }

    @Override
    public void toggleSelectionAll(Vector<Figure> figures) {
        this.toggleSelectionAll(new FigureEnumerator(figures));
    }

    @Deprecated
    public void toggleSelectionAll(FigureEnumeration figures) {
        boolean changed = false;
        while (figures.hasMoreElements()) {
            changed |= this.toggleSelectionInternal(figures.nextFigure());
        }
        if (changed) {
            this.selectionChanged();
        }
    }

    @Override
    public void clearSelection() {
        FigureEnumeration k = this.selectionElements();
        while (k.hasMoreElements()) {
            Figure fig = k.nextFigure();
            fig.removeFigureChangeListener(this);
            fig.invalidate();
        }
        this._selection = new Vector();
        this.selectionInvalidateHandles();
        this.selectionChanged();
    }

    @Override
    public void figureInvalidated(FigureChangeEvent e) {
    }

    @Override
    public void figureChanged(FigureChangeEvent e) {
    }

    @Override
    public void figureRemoved(FigureChangeEvent e) {
        this.removeFromSelection(e.getFigure());
    }

    @Override
    public void figureRequestRemove(FigureChangeEvent e) {
    }

    @Override
    public void figureRequestUpdate(FigureChangeEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectionInvalidateHandles() {
        Object object = this._selectionHandlesLock;
        synchronized (object) {
            this._selectionHandles = null;
        }
    }

    @Override
    public void figureHandlesChanged(FigureChangeEvent e) {
        this.selectionInvalidateHandles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Enumeration<FigureHandle> selectionHandles() {
        Object object = this._selectionHandlesLock;
        synchronized (object) {
            if (this._selectionHandles == null) {
                this._selectionHandles = new Vector();
                FigureEnumeration k = this.selectionElements();
                while (k.hasMoreElements()) {
                    Figure figure = k.nextFigure();
                    Enumeration<FigureHandle> kk = figure.handles().elements();
                    while (kk.hasMoreElements()) {
                        this._selectionHandles.addElement(kk.nextElement());
                    }
                }
            }
            return this._selectionHandles.elements();
        }
    }

    private static void tryAdd(Vector<Figure> vec, Figure obj) {
        if (obj != null && !vec.contains(obj)) {
            vec.addElement(obj);
        }
    }

    public static Vector<Figure> expandFigureVector(Vector<Figure> orgFigures) {
        Vector<Figure> figures = new Vector<Figure>(orgFigures);
        for (int i = 0; i < figures.size(); ++i) {
            Figure figure = figures.elementAt(i);
            if (!(figure instanceof FigureWithDependencies)) continue;
            FigureWithDependencies df = (FigureWithDependencies)figure;
            FigureEnumeration relatedFigures = df.getFiguresWithDependencies();
            while (relatedFigures.hasMoreElements()) {
                StandardDrawingView.tryAdd(figures, relatedFigures.nextFigure());
            }
        }
        return figures;
    }

    @Override
    public de.renew.draw.ui.ontology.FigureSelection getFigureSelection() {
        return new FigureSelection(this.inZOrder(StandardDrawingView.expandFigureVector(this._selection)));
    }

    @Override
    public FigureHandle findHandle(int x, int y) {
        Enumeration<FigureHandle> k = this.selectionHandles();
        while (k.hasMoreElements()) {
            FigureHandle handle = k.nextElement();
            if (!handle.containsPoint(x, y)) continue;
            return handle;
        }
        return null;
    }

    protected void selectionChanged() {
        this._editor.selectionChanged(this);
    }

    @Override
    public Point lastClick() {
        return this._lastClick;
    }

    @Override
    public Point getCurrentMousePosition() {
        return this.getMousePosition();
    }

    @Override
    public void setConstrainer(PointConstrainer c) {
        this._constrainer = c;
    }

    @Override
    public PointConstrainer getConstrainer() {
        return this._constrainer;
    }

    protected Point constrainPoint(Point p) {
        Dimension size = this.getSize();
        p.x = Geom.range(1, size.width, p.x);
        p.y = Geom.range(1, size.height, p.y);
        if (this._constrainer != null) {
            return this._constrainer.constrainPoint(p);
        }
        return p;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        boolean rightClick;
        boolean bl = rightClick = (e.getModifiersEx() & 0x1800) != 0;
        if (this.tool() != this.editor().defaultTool() && rightClick && e.getClickCount() == 1) {
            this.editor().setStickyTools(false);
            this.tool().cancel();
        } else {
            this.requestFocus();
            Point p = this.constrainPoint(new Point(e.getX(), e.getY()));
            this.inverseTransformPoint(p);
            this._lastClick = new Point(e.getX(), e.getY());
            this.tool().mouseDown(e, p.x, p.y);
            this.checkDamage();
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Point p = this.constrainPoint(new Point(e.getX(), e.getY()));
        this.inverseTransformPoint(p);
        this.tool().mouseDrag(e, p.x, p.y);
        this.checkDamage();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Point p = new Point(e.getX(), e.getY());
        this.inverseTransformPoint(p);
        this.tool().mouseMove(e, p.x, p.y);
        this.checkDamage();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        Point p = this.constrainPoint(new Point(e.getX(), e.getY()));
        this.inverseTransformPoint(p);
        this.tool().mouseUp(e, p.x, p.y);
        this.checkDamage();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        Point p = e.getPoint();
        if (e.getWheelRotation() > 0) {
            this.zoomOutFromPoint(p);
        } else {
            this.zoomInOnPoint(p);
        }
    }

    public void zoomInOnPoint(Point p) {
        double factor = Math.min(this._scaleFactor + 0.2, 3.0);
        BigDecimal bd = new BigDecimal(factor).setScale(1, RoundingMode.HALF_UP);
        this.zoomOnPoint(bd.doubleValue(), p);
    }

    public void zoomOutFromPoint(Point p) {
        double factor = Math.max(this._scaleFactor - 0.2, 0.2);
        BigDecimal bd = new BigDecimal(factor).setScale(1, RoundingMode.HALF_UP);
        this.zoomOnPoint(bd.doubleValue(), p);
    }

    public void zoomOnPoint(double factor, Point p) {
        JViewport viewport = (JViewport)this.getParent();
        Point portPos = viewport.getViewPosition();
        Point p2 = new Point(p.x + portPos.x, p.y + portPos.y);
        this.inverseTransformPoint(p2);
        this.changeScalingFactor(factor);
        this._affinetransform.transform(p2, p2);
        int xViewport = Math.max(p2.x - p.x, 0);
        int yViewport = Math.max(p2.y - p.y, 0);
        portPos = new Point(xViewport, yViewport);
        viewport.setViewPosition(portPos);
        this.drawingInvalidated(new CH.ifa.draw.framework.DrawingChangeEvent(this._drawing, this.getBounds()));
        this.checkDamage();
        viewport.repaint();
    }

    public void zoomToFitView(Rectangle rectangle) {
        JViewport viewport = (JViewport)this.getParent();
        Dimension portSize = viewport.getSize();
        double factor = Math.min(Math.min(portSize.getWidth() / rectangle.getWidth(), portSize.getHeight() / rectangle.getHeight()), 3.0);
        this.changeScalingFactor(factor);
        Point rectangleCenter = new Point((int)rectangle.getCenterX(), (int)rectangle.getCenterY());
        this._affinetransform.transform(rectangleCenter, rectangleCenter);
        int xViewport = Math.max(rectangleCenter.x - portSize.width / 2, 0);
        int yViewport = Math.max(rectangleCenter.y - portSize.height / 2, 0);
        Point portPos = new Point(xViewport, yViewport);
        viewport.setViewPosition(portPos);
        viewport.setViewPosition(portPos);
        this.drawingInvalidated(new CH.ifa.draw.framework.DrawingChangeEvent(this._drawing, this.getBounds()));
        this.checkDamage();
        viewport.repaint();
    }

    public double getScalingFactor() {
        return this._scaleFactor;
    }

    public void changeScalingFactor(double newFactor) {
        this._scaleFactor = newFactor;
        this._affinetransform = AffineTransform.getScaleInstance(this._scaleFactor, this._scaleFactor);
        this.editor().showStatus("Zoom factor: " + Double.valueOf(newFactor * 100.0).intValue() + "%");
    }

    @Override
    public AffineTransform getAffineTransform() {
        return this._affinetransform;
    }

    private Point inverseTransformPoint(Point p) {
        if (this._affinetransform != null) {
            try {
                this._affinetransform.inverseTransform(p, p);
            }
            catch (NoninvertibleTransformException e1) {
                LOGGER.error((Object)(e1.getMessage() + String.valueOf(e1)));
            }
        }
        return p;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int code = e.getExtendedKeyCode();
        if (code == 8 || code == 127) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(StandardDrawingView.class.getName() + ": KeyEvent e: Delete pressed"));
            }
            if (!this._selection.isEmpty()) {
                if (e.isAltDown()) {
                    for (Figure figure : this._selection) {
                        figure.setAttribute("DeleteWithChildren", Boolean.TRUE);
                    }
                } else {
                    for (Figure figure : this._selection) {
                        figure.setAttribute("DeleteWithChildren", null);
                    }
                }
                DeleteCommand cmd = new DeleteCommand("Delete");
                ((AbstractCommand)cmd).execute();
            }
        } else if (code == 40 || code == 38 || code == 39 || code == 37) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(StandardDrawingView.class.getName() + ": KeyEvent e: Arrow pressed"));
            }
            this.handleCursorKey(code, e.getModifiersEx());
            if (!this._selection.isEmpty()) {
                e.consume();
            }
        } else if ((e.getModifiersEx() & (Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() | 0x40)) == Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() && (code == 48 || code == 521 || code == 45)) {
            JViewport viewport = (JViewport)this.getParent();
            Point center = new Point(viewport.getWidth() / 2, viewport.getHeight() / 2);
            switch (code) {
                case 48: {
                    this.zoomOnPoint(1.0, center);
                    break;
                }
                case 521: {
                    this.zoomInOnPoint(center);
                    break;
                }
                case 45: {
                    this.zoomOutFromPoint(center);
                }
            }
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)(StandardDrawingView.class.getName() + ": KeyEvent e: Pushing KeyEvent to tool e: " + code + " , " + e.getKeyChar()));
            }
            this.tool().keyDown(e, code);
        }
        this.checkDamage();
    }

    protected void handleCursorKey(int key) {
        this.handleCursorKey(key, 0);
    }

    protected void handleCursorKey(int key, int modifiers) {
        int dx = 0;
        int dy = 0;
        int stepX = 1;
        int stepY = 1;
        if (this._constrainer != null) {
            stepX = this._constrainer.getStepX();
            stepY = this._constrainer.getStepY();
        }
        if ((modifiers & 0x40) != 0) {
            stepX *= 10;
            stepY *= 10;
        }
        switch (key) {
            case 40: {
                dy = stepY;
                break;
            }
            case 38: {
                dy = -stepY;
                break;
            }
            case 39: {
                dx = stepX;
                break;
            }
            case 37: {
                dx = -stepX;
            }
        }
        this._editor.prepareAccumulatedUndoSnapshot();
        this.moveSelection(dx, dy);
        this._editor.triggerAccumulatedUndoSnapshot();
    }

    public static void moveFigures(Vector<Figure> figureVector, int dx, int dy) throws IllegalStateException {
        Vector<Figure> iteratorFigureVector = new Vector<Figure>(figureVector);
        for (Figure figure1 : figureVector) {
            if (!(figure1 instanceof CompositeAttributeFigure)) continue;
            iteratorFigureVector.removeAll(((CompositeAttributeFigure)figure1).getAttached());
        }
        FigureEnumerator figures = new FigureEnumerator(iteratorFigureVector);
        while (figures.hasMoreElements()) {
            Figure figure;
            Figure parent = figure = figures.nextFigure();
            if (figure == null) {
                throw new IllegalStateException();
            }
            while (parent != null) {
                if (parent instanceof ChildFigure) {
                    if ((parent = ((ChildFigure)parent).parent()) == null || !figureVector.contains(parent)) continue;
                    break;
                }
                parent = null;
            }
            if (parent != null) continue;
            figure.moveBy(dx, dy);
        }
    }

    @Override
    public void moveSelection(int dx, int dy) {
        Point p = new Point(dx, dy);
        StandardDrawingView.moveFigures(this._selection, p.x, p.y);
        this.checkDamage();
    }

    @Override
    public synchronized void checkDamage() {
        Enumeration<DrawingChangeListener> each = this.drawing().drawingChangeListeners();
        while (each.hasMoreElements()) {
            DrawingChangeListener l = each.nextElement();
            if (!(l instanceof DrawingView)) continue;
            ((DrawingView)l).repairDamage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void repairDamage() {
        Object object = this._repaintLock;
        synchronized (object) {
            if (this._damage != null) {
                Rectangle r = this._damage;
                if (this._affinetransform != null) {
                    r = this._affinetransform.createTransformedShape(this._damage).getBounds();
                }
                if (r.x + r.width > r.width || r.y + r.height > r.height) {
                    this.checkMinimumSize(r);
                }
                this.repaint(0L, r.x, r.y, r.width, r.height);
                this._damage = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void drawingInvalidated(DrawingChangeEvent e) {
        Object object = this._repaintLock;
        synchronized (object) {
            Rectangle r = e.getInvalidatedRectangle();
            if (r != null) {
                if (this._damage == null) {
                    this._damage = r;
                } else {
                    this._damage.add(r);
                }
            }
        }
    }

    @Override
    public void drawingRequestUpdate(DrawingChangeEvent e) {
        this.repairDamage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this._updateStrategy.draw(g2, this);
        Object object = this._repaintLock;
        synchronized (object) {
            if (this._damage != null) {
                this.repaint(0L, this._damage.x, this._damage.y, this._damage.width, this._damage.height);
                this._damage = null;
            }
        }
    }

    @Override
    public void drawAll(Graphics g) {
        boolean isPrinting = g instanceof PrintGraphics;
        this.drawBackground(g);
        if (this._backgrounds != null && !isPrinting) {
            this.drawPainters(g, this._backgrounds);
        }
        ContextGraphics cg = new ContextGraphics((Graphics2D)g, this.getBackground());
        cg.scale(this._scaleFactor, this._scaleFactor);
        this.drawDrawing(cg);
        if (this._foregrounds != null && !isPrinting) {
            this.drawPainters(g, this._foregrounds);
        }
        if (!isPrinting) {
            this.drawHandles(g);
        }
        cg.scale(1.0 / this._scaleFactor, 1.0 / this._scaleFactor);
        if (this._drawing == this._editor.drawing()) {
            this.tool().draw(cg);
        }
    }

    @Deprecated
    public void drawHandles(Graphics g) {
        Enumeration<FigureHandle> k = this.selectionHandles();
        while (k.hasMoreElements()) {
            k.nextElement().draw(g);
        }
    }

    public void drawDrawing(Graphics g) {
        this._drawing.draw(g);
    }

    public void drawBackground(Graphics g) {
        Color color = this.getBackgroundColor();
        g.setColor(color);
        Rectangle bounds = this.getBounds();
        g.fillRect(0, 0, bounds.width, bounds.height);
    }

    protected Color getBackgroundColor() {
        Color color = DockUI.getColor((String)"dock.background");
        return color.brighter();
    }

    private void drawPainters(Graphics g, Vector<Painter> v) {
        for (int i = 0; i < v.size(); ++i) {
            v.elementAt(i).draw(g, this);
        }
    }

    public void addBackground(Painter painter) {
        if (this._backgrounds == null) {
            this._backgrounds = new Vector(3);
        }
        this._backgrounds.addElement(painter);
        this.repaint();
    }

    public void removeBackground(Painter painter) {
        if (this._backgrounds != null) {
            this._backgrounds.removeElement(painter);
        }
        this.repaint();
    }

    public void removeForeground(Painter painter) {
        if (this._foregrounds != null) {
            this._foregrounds.removeElement(painter);
        }
        this.repaint();
    }

    public void addForeground(Painter painter) {
        if (this._foregrounds == null) {
            this._foregrounds = new Vector(3);
        }
        this._foregrounds.addElement(painter);
        this.repaint();
    }

    @Override
    public void freezeView() {
    }

    @Override
    public void unfreezeView() {
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        this._selection = new Vector();
        this._selectionHandlesLock = new Object();
        this._repaintLock = new Object();
        if (this._drawing != null) {
            this._drawing.addDrawingChangeListener(this);
        }
    }

    private void checkMinimumSize(Rectangle area) {
        if (area == null) {
            area = this._drawing.getBounds();
        }
        Dimension d = new Dimension(area.x + area.width, area.y + area.height);
        if (this._viewSize.height < d.height) {
            this._viewSize.height = d.height + 10;
        }
        if (this._viewSize.width < d.width) {
            this._viewSize.width = d.width + 10;
        }
        Dimension guiSize = this.getSize();
        boolean changed = false;
        if (guiSize.width < this._viewSize.width) {
            guiSize.width = this._viewSize.width;
            changed = true;
        }
        if (guiSize.height < this._viewSize.height) {
            guiSize.height = this._viewSize.height;
            changed = true;
        }
        if (changed) {
            this.setSize(guiSize.width, guiSize.height);
        }
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void showElement(Figure fig) {
        Container c;
        for (c = this.getParent(); c != null && !(c instanceof JScrollPane); c = c.getParent()) {
        }
        if (c != null) {
            JScrollPane pane = (JScrollPane)c;
            Point p = fig.center();
            int x = p.x - pane.getWidth() / 2;
            int y = p.y - pane.getHeight() / 2;
            int vpWidth = pane.getViewport().getWidth();
            int vpHeight = pane.getViewport().getHeight();
            int vWidth = pane.getViewport().getView().getWidth();
            int vHeight = pane.getViewport().getView().getHeight();
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            if (x + vpWidth > vWidth) {
                x = vWidth - vpWidth;
            }
            if (y + vpHeight > vHeight) {
                y = vHeight - vpHeight;
            }
            pane.getViewport().setViewPosition(new Point(x, y));
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (pageIndex >= 1) {
            return 1;
        }
        if (graphics instanceof Graphics2D) {
            Graphics2D g2 = (Graphics2D)graphics;
            g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            double sH = pageFormat.getImageableHeight() / (double)this.getHeight();
            double sW = pageFormat.getImageableWidth() / (double)this.getWidth();
            double scale = Math.min(sH, sW);
            if (scale < 1.0) {
                g2.scale(scale, scale);
            }
            this.drawAll(graphics);
            return 0;
        }
        return 1;
    }
}

