/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.standard.StandardDrawingView;
import bibliothek.gui.dock.common.DefaultMultipleCDockable;
import bibliothek.gui.dock.common.MultipleCDockableFactory;
import bibliothek.gui.dock.common.action.CAction;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class StandardDrawingViewContainer
extends DefaultMultipleCDockable {
    private final JScrollPane _scrollPane;
    private StandardDrawingView _view;
    private static final int VERTICAL_SCROLL_INCREMENT = 75;
    private static final int HORIZONTAL_SCROLL_INCREMENT = 75;

    public StandardDrawingViewContainer(MultipleCDockableFactory<?, ?> factory, StandardDrawingView view) {
        super(factory, new CAction[0]);
        this.setCloseable(true);
        this.setRemoveOnClose(true);
        this._view = view;
        InputEventForwarder forwarder = new InputEventForwarder();
        view.addMouseListener(forwarder);
        view.addMouseMotionListener(forwarder);
        view.addKeyListener(forwarder);
        this._scrollPane = new JScrollPane(view, 22, 32);
        this._scrollPane.getViewport().setScrollMode(1);
        this._scrollPane.setAutoscrolls(true);
        this._scrollPane.getVerticalScrollBar().setUnitIncrement(75);
        this._scrollPane.getHorizontalScrollBar().setUnitIncrement(75);
        this._scrollPane.addMouseWheelListener(forwarder);
        this.add(this._scrollPane);
    }

    public StandardDrawingView getView() {
        return this._view;
    }

    public JScrollPane getScrollPane() {
        return this._scrollPane;
    }

    public void clean() {
        this.getView().getParent().remove(this.getView());
        this._view = null;
    }

    private class InputEventForwarder
    implements KeyListener,
    MouseMotionListener,
    MouseListener,
    MouseWheelListener {
        private boolean _active = true;

        @Override
        public void mouseClicked(MouseEvent e) {
            if (this._active) {
                StandardDrawingViewContainer.this._view.mouseClicked(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            if (this._active) {
                StandardDrawingViewContainer.this._view.mousePressed(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this._active) {
                StandardDrawingViewContainer.this._view.mouseReleased(e);
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            if (this._active) {
                StandardDrawingViewContainer.this._view.mouseEntered(e);
            }
        }

        @Override
        public void mouseExited(MouseEvent e) {
            if (this._active) {
                StandardDrawingViewContainer.this._view.mouseExited(e);
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this._active) {
                Rectangle r = new Rectangle(e.getX(), e.getY(), 1, 1);
                ((JPanel)e.getSource()).scrollRectToVisible(r);
                StandardDrawingViewContainer.this._view.mouseDragged(e);
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (this._active) {
                StandardDrawingViewContainer.this._view.mouseMoved(e);
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            if (this._active) {
                StandardDrawingViewContainer.this._view.keyTyped(e);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (this._active) {
                StandardDrawingViewContainer.this._view.keyPressed(e);
            }
            if (this._active && (e.getKeyCode() == 17 || e.getKeyCode() == 157 || e.getKeyCode() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx())) {
                StandardDrawingViewContainer.this._scrollPane.setWheelScrollingEnabled(false);
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (this._active) {
                StandardDrawingViewContainer.this._view.keyReleased(e);
            }
            if (this._active && (e.getKeyCode() == 17 || e.getKeyCode() == 157 || e.getKeyCode() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx())) {
                StandardDrawingViewContainer.this._scrollPane.setWheelScrollingEnabled(true);
            }
        }

        public void discard() {
            this._active = false;
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (e.getModifiersEx() == Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()) {
                StandardDrawingViewContainer.this._view.mouseWheelMoved(e);
                StandardDrawingViewContainer.this._scrollPane.repaint();
            }
        }
    }
}

