/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.util.Animatable;
import de.renew.draw.ui.ontology.DrawingView;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;

public class Animator
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(Animator.class);
    private static final int MAX_DELAY = 62;
    private static final int MIN_DELAY = 15;
    private final DrawingView _view;
    private final Animatable _animatable;
    private boolean _isRunning;

    public Animator(Animatable animatable, DrawingView view) {
        this._view = view;
        this._animatable = animatable;
    }

    public void end() {
        this._animatable.animationStop();
        this._isRunning = false;
    }

    @Override
    public void run() {
        this._isRunning = true;
        this._animatable.animationStart();
        Runnable nextStep = () -> {
            this._animatable.animationStep();
            this._view.checkDamage();
        };
        while (this._isRunning) {
            block6: {
                long tm = System.currentTimeMillis();
                try {
                    EventQueue.invokeAndWait(nextStep);
                }
                catch (InterruptedException e) {
                    break;
                }
                catch (InvocationTargetException e) {
                    LOGGER.warn((Object)e.getMessage());
                    if (!LOGGER.isDebugEnabled()) break block6;
                    LOGGER.debug((Object)(Animator.class.getSimpleName() + ": " + String.valueOf(e)));
                }
            }
            try {
                Thread.sleep(Math.max(15L, (tm += 62L) - System.currentTimeMillis()));
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }
}

