/*
 * Decompiled with CFR 0.152.
 */
package de.renew.draw.storables.api;

import de.renew.draw.storables.api.services.StorableService;
import de.renew.draw.storables.impl.services.StorableServiceImpl;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.DrawingChangeEvent;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureChangeEvent;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.storables.ontology.Locator;
import de.renew.draw.storables.ontology.Storable;
import de.renew.draw.storables.ontology.StorableInput;
import de.renew.draw.storables.ontology.StorableOutput;
import de.renew.ioontology.ExtensionFileFilter;
import de.renew.ioontology.MultiExtensionFileFilter;
import de.renew.ioontology.exporting.ExportFormat;
import de.renew.ioontology.importing.ImportFormat;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import java.util.function.Predicate;

public final class StorableApi {
    private static StorableService _service = new StorableServiceImpl();

    public static StorableInput createStorableInput(InputStream stream) {
        return _service.createStorableInput(stream);
    }

    public static StorableInput createStorableInput(InputStream stream, boolean useUTF8) {
        return _service.createStorableInput(stream, useUTF8);
    }

    public static StorableInput createStorableInput(URL location, boolean useUTF8) throws IOException {
        return _service.createStorableInput(location, useUTF8);
    }

    public static StorableInput createStorableInput(String string) {
        return _service.createStorableInput(string);
    }

    public static StorableInput createPatchingStorableInput(InputStream stream) {
        return _service.createPatchingStorableInput(stream);
    }

    public static StorableInput createPatchingStorableInput(URL location, boolean useUTF8) throws IOException {
        return _service.createPatchingStorableInput(location, useUTF8);
    }

    public static StorableOutput createStorableOutput(File file) throws FileNotFoundException {
        return _service.createStorableOutput(file);
    }

    public static StorableOutput createStorableOutput(OutputStream stream) {
        return _service.createStorableOutput(stream);
    }

    public static <S extends Storable> S cloneStorable(S original) throws Exception {
        return _service.cloneStorable(original);
    }

    public static FigureEnumeration createFilteredFigureEnumerator(FigureEnumeration enumeration, Predicate<Figure> predicate) {
        return _service.createFilteredFigureEnumerator(enumeration, predicate);
    }

    public static FigureEnumeration createMergedFigureEnumerator(FigureEnumeration enumA, FigureEnumeration enumB) {
        return _service.createMergedFigureEnumerator(enumA, enumB);
    }

    public static boolean isDrawingNullDrawing(Drawing drawing) {
        return _service.isDrawingNullDrawing(drawing);
    }

    public static DrawingChangeEvent createDrawingChangeEvent(Drawing source, Rectangle r) {
        return _service.createDrawingChangeEvent(source, r);
    }

    public static FigureChangeEvent createFigureChangeEvent(Figure figure, Rectangle rectangle) {
        return _service.createFigureChangeEvent(figure, rectangle);
    }

    public static FigureChangeEvent createFigureChangeEvent(Figure figure) {
        return _service.createFigureChangeEvent(figure);
    }

    public static Locator createElbowTextLocator() {
        return _service.createElbowTextLocator();
    }

    public static Locator createOffsetLocator(Locator locator) {
        return _service.createOffsetLocator(locator);
    }

    public static Locator createOffsetLocator(Locator locator, int offsetX, int offsetY) {
        return _service.createOffsetLocator(locator, offsetX, offsetY);
    }

    public static MultiExtensionFileFilter getKnownDrawingTypesFileFilter() {
        return _service.getKnownDrawingTypesFileFilter();
    }

    public static ExtensionFileFilter getExtensionFileFilterByDrawingType(String drawingType) {
        return _service.getExtensionFileFilterByDrawingType(drawingType);
    }

    public static void registerDrawingType(String drawingType, ExtensionFileFilter fileFilter) {
        _service.registerDrawingType(drawingType, fileFilter);
    }

    public static void unregisterDrawingType(String drawingType) {
        _service.unregisterDrawingType(drawingType);
    }

    public static Drawing createDrawingForDrawingType(String drawingType) {
        return _service.createDrawingForDrawingType(drawingType);
    }

    public static void addExportFormat(ExportFormat<Drawing> exportFormat) {
        _service.addExportFormat(exportFormat);
    }

    public static void removeExportFormat(ExportFormat<Drawing> exportFormat) {
        _service.removeExportFormat(exportFormat);
    }

    public static List<ExportFormat<Drawing>> getExportFormats() {
        return _service.getExportFormats();
    }

    public static void addImportFormat(ImportFormat<Drawing> importFormat) {
        _service.addImportFormat(importFormat);
    }

    public static void removeImportFormat(ImportFormat<Drawing> importFormat) {
        _service.removeImportFormat(importFormat);
    }

    public static List<ImportFormat<Drawing>> getImportFormats() {
        return _service.getImportFormats();
    }
}

