/*
 * Decompiled with CFR 0.152.
 */
package de.renew.draw.ui.impl.menus;

import CH.ifa.draw.util.CommandMenu;
import de.renew.draw.storables.impl.drawings.DrawingImportFormatHolder;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.ui.api.ApplicationApi;
import de.renew.draw.ui.api.CommandApi;
import de.renew.draw.ui.api.DialogApi;
import de.renew.draw.ui.api.EditorApi;
import de.renew.draw.ui.ontology.AbstractCommand;
import de.renew.ioontology.ExtensionFileFilter;
import de.renew.ioontology.FileFilter;
import de.renew.ioontology.MultiExtensionFileFilter;
import de.renew.ioontology.MultiExtensionFileFilterImpl;
import de.renew.ioontology.importing.ImportFormat;
import de.renew.ioontology.importing.ImportFormatListener;
import de.renew.ioontology.importing.ImportFormatMulti;
import java.awt.Component;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class ImportMenuHolder {
    private static final Logger LOGGER = Logger.getLogger(ImportMenuHolder.class);
    private final CommandMenu _importMenu = new CommandMenu("Import");

    public ImportMenuHolder() {
        AbstractCommand command = CommandApi.createCommand("Import (any type)", this::executeImportAll);
        this._importMenu.add(command);
        DrawingImportFormatHolder.getInstance().addImportFormatListener(this.createImportFormatListener());
    }

    public JMenu getImportMenu() {
        return this._importMenu;
    }

    private List<ImportFormat<Drawing>> getImportFormats() {
        return DrawingImportFormatHolder.getInstance().getImportFormats();
    }

    private FileFilter getImportFileFilter() {
        List<ImportFormat<Drawing>> formats = this.getImportFormats();
        MultiExtensionFileFilterImpl fileFilter = new MultiExtensionFileFilterImpl("All");
        for (ImportFormat<Drawing> format : formats) {
            FileFilter fileFilter2 = format.fileFilter();
            if (fileFilter2 instanceof MultiExtensionFileFilter) {
                MultiExtensionFileFilter multi = (MultiExtensionFileFilter)fileFilter2;
                fileFilter.addAll(multi.getFileFilters());
                continue;
            }
            fileFilter2 = format.fileFilter();
            if (!(fileFilter2 instanceof ExtensionFileFilter)) continue;
            ExtensionFileFilter ext = (ExtensionFileFilter)fileFilter2;
            fileFilter.add(ext);
        }
        return fileFilter;
    }

    private void executeImportAll() {
        ApplicationApi.showStatus("import...");
        File[] files = DialogApi.showSelectFilesDialog(this.getImportFileFilter());
        if (files != null) {
            for (File currentFile : files) {
                Object choice;
                LinkedList<ImportFormat<Drawing>> list = new LinkedList<ImportFormat<Drawing>>();
                ImportFormat impFormat = null;
                for (int posFormat = 0; posFormat < this.getImportFormats().size(); ++posFormat) {
                    try {
                        if (!this.getImportFormats().get(posFormat).canImport(currentFile.toURI().toURL())) continue;
                        list.add(this.getImportFormats().get(posFormat));
                        continue;
                    }
                    catch (MalformedURLException e) {
                        LOGGER.error((Object)e.getMessage(), (Throwable)e);
                        ApplicationApi.showStatus(e.toString());
                    }
                }
                if (list.size() == 1) {
                    impFormat = (ImportFormat)list.get(0);
                } else if (list.size() > 1 && (choice = JOptionPane.showInputDialog(null, "Choose", "ExportFormats", 2, null, list.toArray(), list.get(0))) != null) {
                    impFormat = (ImportFormat)choice;
                }
                if (impFormat != null) {
                    try {
                        this.loadDrawings(new URL[]{currentFile.toURI().toURL()}, impFormat);
                    }
                    catch (MalformedURLException e) {
                        LOGGER.error((Object)e.getMessage(), (Throwable)e);
                        ApplicationApi.showStatus(e.toString());
                    }
                    continue;
                }
                ApplicationApi.showStatus("no import Format");
            }
        }
    }

    private void loadDrawings(URL[] files, ImportFormat<Drawing> format) {
        try {
            List<Drawing> drawings;
            if (files != null && files.length > 0 && (drawings = format.importFiles(files)) != null) {
                for (Drawing d : drawings) {
                    EditorApi.openDrawing(d);
                    ApplicationApi.showStatus("import");
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)e.getMessage(), (Throwable)e);
            ApplicationApi.showStatus(e.toString());
        }
    }

    private void buildImportFormat(ImportFormat<Drawing> importFormat, CommandMenu parent) {
        if (importFormat instanceof ImportFormatMulti) {
            ImportFormatMulti multi = (ImportFormatMulti)importFormat;
            List formats = multi.getImportFormats();
            CommandMenu menu = new CommandMenu(multi.formatName());
            for (ImportFormat<Drawing> importFormat2 : formats) {
                this.buildImportFormat(importFormat2, menu);
            }
            parent.add(menu);
        } else {
            ImportFormatCommand command = this.generateImportCommand(importFormat);
            parent.add(command);
        }
    }

    private ImportFormatCommand generateImportCommand(ImportFormat<Drawing> format) {
        return new ImportFormatCommand(format){

            @Override
            public void execute() {
                ApplicationApi.showStatus("import ...");
                File[] files = DialogApi.showSelectFilesDialog(this.format().fileFilter());
                URL[] paths = new URL[files.length];
                for (int pos = 0; pos < paths.length; ++pos) {
                    try {
                        paths[pos] = files[pos].toURI().toURL();
                        continue;
                    }
                    catch (MalformedURLException e) {
                        LOGGER.error((Object)e.getMessage(), (Throwable)e);
                        ApplicationApi.showStatus(e.toString());
                    }
                }
                ImportMenuHolder.this.loadDrawings(paths, this.format());
                EditorApi.toolDone();
                ApplicationApi.showStatus("import");
            }
        };
    }

    void addImportFormat(ImportFormat<Drawing> importFormat) {
        LOGGER.debug((Object)(String.valueOf(this.getClass()) + ": adding import format " + String.valueOf(importFormat)));
        this.buildImportFormat(importFormat, this._importMenu);
    }

    void removeImportFormat(ImportFormat<Drawing> importFormat) {
        Component[] ele;
        for (Component component : ele = this._importMenu.getMenuComponents()) {
            JMenuItem item;
            if (!(component instanceof JMenuItem) || !(item = (JMenuItem)component).getText().equals(importFormat.formatName())) continue;
            this._importMenu.remove(item);
        }
    }

    private ImportFormatListener<Drawing> createImportFormatListener() {
        return new ImportFormatListener<Drawing>(){

            @Override
            public void importFormatAdded(ImportFormat<Drawing> addedFormat) {
                ImportMenuHolder.this.addImportFormat(addedFormat);
            }

            @Override
            public void importFormatRemoved(ImportFormat<Drawing> removedFormat) {
                ImportMenuHolder.this.removeImportFormat(removedFormat);
            }
        };
    }

    private static abstract class ImportFormatCommand
    extends AbstractCommand {
        private final ImportFormat<Drawing> _format;

        private ImportFormatCommand(ImportFormat<Drawing> format) {
            super(format.formatName());
            this._format = format;
        }

        public ImportFormat<Drawing> format() {
            return this._format;
        }
    }
}

