/*
 * Decompiled with CFR 0.152.
 */
package de.renew.ioontology.exporting;

import CH.ifa.draw.io.CombinationFileFilter;
import de.renew.ioontology.ExtensionFileFilter;
import de.renew.ioontology.FileFilter;
import de.renew.ioontology.MultiExtensionFileFilter;
import de.renew.ioontology.MultiExtensionFileFilterImpl;
import de.renew.ioontology.exporting.ExportFormat;
import de.renew.ioontology.exporting.ExportFormatAbstract;
import de.renew.ioontology.exporting.ExportFormatMulti;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public abstract class ExportFormatMultiAbstract<T>
extends ExportFormatAbstract<T>
implements ExportFormatMulti<T> {
    private final List<ExportFormat<T>> _formats = new LinkedList<ExportFormat<T>>();

    public ExportFormatMultiAbstract(String name, String filterName) {
        super(name, new MultiExtensionFileFilterImpl(filterName));
    }

    private MultiExtensionFileFilter multiFileFilter() {
        MultiExtensionFileFilter result = (MultiExtensionFileFilter)this.fileFilter();
        Objects.requireNonNull(result, "Failure in ExportFormatAbstract: result == null");
        return result;
    }

    private void addFileFilter(FileFilter fileFilter) {
        if (fileFilter instanceof CombinationFileFilter) {
            CombinationFileFilter comFileFilter = (CombinationFileFilter)fileFilter;
            for (FileFilter fileFilter2 : comFileFilter.getFileFilters()) {
                this.addFileFilter(fileFilter2);
            }
        } else if (fileFilter instanceof MultiExtensionFileFilter) {
            MultiExtensionFileFilter multiFilter = (MultiExtensionFileFilter)fileFilter;
            for (ExtensionFileFilter extensionFileFilter : multiFilter.getFileFilters()) {
                this.addFileFilter(extensionFileFilter);
            }
        } else if (fileFilter instanceof ExtensionFileFilter) {
            this.multiFileFilter().add((ExtensionFileFilter)fileFilter);
        }
    }

    private void removeFileFilter(FileFilter fileFilter) {
        if (fileFilter instanceof CombinationFileFilter) {
            CombinationFileFilter comFileFilter = (CombinationFileFilter)fileFilter;
            for (FileFilter fileFilter2 : comFileFilter.getFileFilters()) {
                this.removeFileFilter(fileFilter2);
            }
        } else if (fileFilter instanceof MultiExtensionFileFilter) {
            MultiExtensionFileFilter multiFilter = (MultiExtensionFileFilter)fileFilter;
            for (ExtensionFileFilter extensionFileFilter : multiFilter.getFileFilters()) {
                this.removeFileFilter(extensionFileFilter);
            }
        } else if (fileFilter instanceof ExtensionFileFilter) {
            this.multiFileFilter().remove((ExtensionFileFilter)fileFilter);
        }
    }

    @Override
    public void addExportFormat(ExportFormat<T> format) {
        this._formats.add(format);
        this.addFileFilter(format.fileFilter());
    }

    @Override
    public List<ExportFormat<T>> getExportFormats() {
        return this._formats;
    }

    @Override
    public void removeExportFormat(ExportFormat<T> format) {
        this.removeFileFilter(format.fileFilter());
        this._formats.remove(format);
    }

    @Override
    public boolean canExportNto1() {
        return false;
    }

    @Override
    public ExportFormat<T>[] canExport(File path) {
        ExportFormat<T>[] result = super.canExport(path);
        if (path != null) {
            LinkedList<ExportFormat<T>[]> list = new LinkedList<ExportFormat<T>[]>();
            int count = 0;
            for (int pos = 0; pos < this.getExportFormats().size(); ++pos) {
                ExportFormat<T>[] formats = this.getExportFormats().get(pos).canExport(path);
                if (formats.length <= 0) continue;
                list.add(formats);
                count += formats.length;
            }
            result = new ExportFormat[count];
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ExportFormat[] element;
                for (ExportFormat exportFormat : element = (ExportFormat[])iterator.next()) {
                    result[--count] = exportFormat;
                }
            }
        }
        Objects.requireNonNull(result, "Failure in ExportFormatMultiAbstract: result == null");
        return result;
    }
}

