/*
 * Decompiled with CFR 0.152.
 */
package de.renew.imagenetdiff;

import CH.ifa.draw.io.DrawingFileHelper;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.ui.ontology.StatusDisplayer;
import de.renew.imagenetdiff.DiffExecutor;
import de.renew.plugin.command.CLCommand;
import java.io.File;
import java.io.PrintStream;
import org.apache.log4j.Logger;

public abstract class AbstractDiffClCommand
implements CLCommand,
CH.ifa.draw.io.StatusDisplayer {
    private static final Logger LOGGER = Logger.getLogger(AbstractDiffClCommand.class);
    String _command = "no name";
    DiffExecutor _diffCommand;
    final String[] _ext = new String[]{"", ".rnw", ".aip", ".draw", ".arm", ".mad"};

    public void execute(String[] args, PrintStream response) {
        String filename1;
        int index = 0;
        boolean quiteMode = false;
        if (args.length > 0 && args[index].equals("-q")) {
            quiteMode = true;
            ++index;
        }
        if (args.length - index == 0) {
            this.showStatus("No args gives. Synopsys: " + this.getName() + " [-q] file1 [file2]");
        }
        block0: while (args.length - index >= 2) {
            filename1 = args[index++];
            String filename2 = args[index++];
            String[] stringArray = this._ext;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String ext = stringArray[i];
                this.showStatus("Diff: trying files: " + filename1 + ext + " and " + filename2 + ext);
                File file1 = new File(filename1 + ext);
                File file2 = new File(filename2 + ext);
                if (file1.exists() && file2.exists()) {
                    Drawing drawing1 = DrawingFileHelper.loadDrawing((File)file1, (StatusDisplayer)this);
                    Drawing drawing2 = DrawingFileHelper.loadDrawing((File)file2, (StatusDisplayer)this);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)(AbstractDiffClCommand.class.getSimpleName() + ": first drawing to diff: " + drawing1.getFilename().getPath()));
                        LOGGER.debug((Object)(AbstractDiffClCommand.class.getSimpleName() + ": second drawing to diff: " + drawing2.getFilename().getPath()));
                    }
                    this._diffCommand.doDiff((StatusDisplayer)this, drawing1, drawing2, quiteMode);
                    continue block0;
                }
                this.showStatus("One or more files do not exist: " + filename1 + ", " + filename2);
            }
        }
        if (args.length - index == 1) {
            filename1 = args[index];
            for (String ext : this._ext) {
                this.showStatus("Diff (svn base): trying file: " + filename1 + ext);
                File file1 = new File(filename1 + ext);
                if (file1.exists()) {
                    String filename2;
                    File file2;
                    String path = file1.getParent();
                    String name = file1.getName();
                    Object pathPrefix = "";
                    if (path != null) {
                        pathPrefix = path + File.separator;
                    }
                    if ((file2 = new File(filename2 = (String)pathPrefix + ".svn" + File.separator + "text-base" + File.separator + name + ".svn-base")).exists()) {
                        Drawing drawing1 = DrawingFileHelper.loadDrawing((File)file1, (StatusDisplayer)this);
                        Drawing drawing2 = DrawingFileHelper.loadDrawing((File)file2, (StatusDisplayer)this);
                        this._diffCommand.doDiff((StatusDisplayer)this, drawing1, drawing2, quiteMode);
                        break;
                    }
                    this.showStatus("Could not find file: " + filename2);
                    break;
                }
                this.showStatus("File " + args[index] + ext + " does not exist.");
            }
        }
    }

    protected String getName() {
        return this._command;
    }

    public void showStatus(String message) {
        LOGGER.info((Object)message);
    }

    public String getArguments() {
        return "[-q] fileNames fileNames";
    }
}

