/*
 * Decompiled with CFR 0.152.
 */
package de.renew.imagenetdiff;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.IOHelper;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.io.DrawingFileHelper;
import CH.ifa.draw.util.Command;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.ui.ontology.StatusDisplayer;
import de.renew.imagenetdiff.AbstractDiffClCommand;
import de.renew.imagenetdiff.DiffExecutor;
import de.renew.ioontology.MultiExtensionFileFilterImpl;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public abstract class AbstractDiffCommand
extends Command
implements DiffExecutor {
    private static final Logger LOGGER = Logger.getLogger(AbstractDiffCommand.class);
    private String _imageExtension;

    public AbstractDiffCommand(String name) {
        super(name);
    }

    public void setImageExtension(String imageExtension) {
        this._imageExtension = imageExtension;
    }

    public String getImageExtension() {
        return this._imageExtension;
    }

    public void execute() {
        Drawing drawing2;
        Drawing drawing1;
        DrawPlugin guiPlugin = DrawPlugin.getCurrent();
        DrawApplication gui = DrawPlugin.getGui();
        JFrame frame = gui.getFrame();
        try {
            Runtime.getRuntime().exec("compare --version");
        }
        catch (IOException e2) {
            LOGGER.error((Object)e2.getMessage());
            LOGGER.debug((Object)e2.getMessage(), (Throwable)e2);
            JOptionPane.showMessageDialog(frame, "ImageMagick not found!", "ImageMagick not found!", 0);
            return;
        }
        Enumeration en = gui.drawings();
        int i = 0;
        while (en.hasMoreElements()) {
            en.nextElement();
            ++i;
        }
        Drawing[] d = new Drawing[2];
        int check = 1;
        if (i == 2) {
            Enumeration enu = gui.drawings();
            i = 0;
            while (enu.hasMoreElements()) {
                d[i++] = (Drawing)enu.nextElement();
            }
            String message = "Exactly two drawing are opened: " + d[0].getName() + " and " + d[1].getName() + ".\n Would you like to compare these?";
            String title = "Create diff...";
            check = JOptionPane.showOptionDialog(frame, message, title, 0, 3, null, null, null);
        }
        assert (guiPlugin != null);
        IOHelper io = guiPlugin.getIOHelper();
        MultiExtensionFileFilterImpl ff = io.getFileFilterKnownTypes();
        if (check == 0) {
            drawing1 = d[0];
            drawing2 = d[1];
        } else {
            String dir = System.getProperty("user.dir");
            Object[] file1 = io.getLoadPath(new File(dir), (FileFilter)ff, false);
            Object[] file2 = io.getLoadPath(new File(dir), (FileFilter)ff, false);
            System.out.println(Arrays.toString(file1));
            System.out.println(Arrays.toString(file2));
            if (file1 != null && file2 != null && file1.length > 0 && file2.length > 0 && file1[0] != null && file2[0] != null) {
                drawing1 = DrawingFileHelper.loadDrawing((File)file1[0], (StatusDisplayer)gui);
                drawing2 = DrawingFileHelper.loadDrawing((File)file2[0], (StatusDisplayer)gui);
            } else {
                return;
            }
        }
        this.doDiff((StatusDisplayer)gui, drawing1, drawing2, false);
    }

    protected void exchangeColor(String name, int fuzz, String oldColor, String newColor) {
        LOGGER.debug((Object)("exchangeColor called with: " + fuzz + " " + oldColor + " " + newColor));
        Process process = null;
        try {
            String cvrtstr = "convert " + name + this.getImageExtension() + " -fuzz " + fuzz + "% -fill " + newColor + "  -opaque " + oldColor + " " + name + this.getImageExtension();
            LOGGER.info((Object)(Object.class.getName() + ": Convert String:\n" + cvrtstr));
            process = Runtime.getRuntime().exec(cvrtstr);
        }
        catch (Exception e1) {
            LOGGER.error((Object)e1.getMessage());
            LOGGER.debug((Object)e1.getMessage(), (Throwable)e1);
        }
        if (process != null) {
            try {
                int exit = process.waitFor();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)(AbstractDiffClCommand.class.getSimpleName() + ": process' exit code = " + exit));
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

