/*
 * Decompiled with CFR 0.152.
 */
package de.renew.minimap.component;

import CH.ifa.draw.standard.StandardDrawingView;
import CH.ifa.draw.standard.StandardDrawingViewContainer;
import bibliothek.gui.dock.common.event.CFocusListener;
import bibliothek.gui.dock.common.intern.CDockable;
import de.renew.draw.ui.ontology.DrawingView;
import de.renew.draw.ui.ontology.Painter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JViewport;
import org.apache.log4j.Logger;

public class MiniMapPanel
extends JPanel
implements ComponentListener,
MouseListener,
CFocusListener,
MouseMotionListener,
Painter {
    private static final Logger LOGGER = Logger.getLogger(MiniMapPanel.class);
    private StandardDrawingView _drawingView;
    private JViewport _viewport;

    public MiniMapPanel() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setLayout(new BoxLayout(this, 1));
        this.repaint();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.repaint();
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.repaint();
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int y;
        int x;
        if (this._drawingView == null) {
            return;
        }
        double normalizeFactor = this.calculateNormalizeFactor();
        AffineTransform at = AffineTransform.getScaleInstance(normalizeFactor, normalizeFactor);
        Point p = new Point(e.getX(), e.getY());
        try {
            at.inverseTransform(p, p);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        at = this._drawingView.getAffineTransform();
        if (at != null) {
            at = (AffineTransform)at.clone();
            x = p.x;
            y = p.y;
            p = new Point(x, y);
            at.transform(p, p);
        }
        x = p.x;
        y = p.y;
        x = p.x - this._viewport.getWidth() / 2;
        y = p.y - this._viewport.getHeight() / 2;
        this._drawingView.requestFocusInWindow();
        this._drawingView.setBounds(-x, -y, this._drawingView.getBounds().width, this._drawingView.getBounds().height);
        e.consume();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this._drawingView == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        double normalizeFactor = this.calculateNormalizeFactor();
        g2.scale(normalizeFactor, normalizeFactor);
        this._drawingView.drawBackground(g);
        this._drawingView.drawDrawing(g);
        int x = this._viewport.getX() - this._drawingView.getX();
        int width = this._viewport.getWidth();
        int y = this._viewport.getY() - this._drawingView.getY();
        int height = this._viewport.getHeight();
        AffineTransform at = this._drawingView.getAffineTransform();
        if (at != null) {
            try {
                Point p = new Point(x, y);
                at.inverseTransform(p, p);
                x = p.x;
                y = p.y;
                p = new Point(width, height);
                at.inverseTransform(p, p);
                width = p.x;
                height = p.y;
            }
            catch (NoninvertibleTransformException e) {
                System.err.println("DrawingView for drawing " + this._drawingView.drawing().getName() + " had an irreversible affine transformation.");
                System.err.println("The viewport indicator of the MiniMap was not correctly reshaped, otherwise everything should be fine.");
                e.printStackTrace();
            }
        }
        g.setColor(Color.red);
        g.drawRect(x, y, width, height);
        Color color = new Color(55, 55, 55, 10);
        g.setColor(color);
        g.fillRect(x, y, width, height);
    }

    private double calculateNormalizeFactor() {
        if (this._drawingView == null) {
            return 1.0;
        }
        int drawingWidth = this._drawingView.getWidth();
        double panelWidth = this.getWidth();
        int drawingHeight = this._drawingView.getHeight();
        double panelHeight = this.getHeight();
        AffineTransform at = this._drawingView.getAffineTransform();
        if (at != null) {
            try {
                Point p = new Point(drawingWidth, drawingHeight);
                at.inverseTransform(p, p);
                drawingWidth = p.x;
                drawingHeight = p.y;
            }
            catch (NoninvertibleTransformException e) {
                LOGGER.error((Object)("DrawingView for drawing " + this._drawingView.drawing().getName() + " had an irreversible affine transformation."));
                LOGGER.error((Object)"The drawing of the MiniMap was not correctly reshaped, otherwise everything should be fine.");
                e.printStackTrace();
            }
        }
        double normalizeWidth = panelWidth / (double)drawingWidth;
        double normalizeHeight = panelHeight / (double)drawingHeight;
        return Math.min(normalizeHeight, normalizeWidth);
    }

    public void focusGained(CDockable cDockable) {
        StandardDrawingView view;
        if (cDockable instanceof StandardDrawingViewContainer && (view = ((StandardDrawingViewContainer)cDockable).getView()) != this._drawingView) {
            if (this._drawingView != null) {
                this._drawingView.removeForeground((Painter)this);
            }
            this._drawingView = view;
            this._drawingView.addForeground((Painter)this);
            this._viewport = ((StandardDrawingViewContainer)cDockable).getScrollPane().getViewport();
            this.repaint();
        }
    }

    public void focusLost(CDockable cDockable) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseClicked(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public void draw(Graphics g, DrawingView view) {
        this.repaint();
    }
}

