/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.util.Animatable;
import CH.ifa.draw.util.Animator;
import CH.ifa.draw.util.GUIProperties;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.ui.api.MenuApi;
import de.renew.draw.ui.api.UndoRedoApi;
import de.renew.draw.ui.ontology.DrawingEditor;
import de.renew.draw.ui.ontology.DrawingView;
import de.renew.gui.AnnealingGraphLayout;
import de.renew.gui.GraphLayout;
import de.renew.gui.LayoutableDrawing;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;

public class AutomaticLayoutFrame
implements AdjustmentListener,
Animatable {
    private static final int width = 200;
    private static final String[] buttonTexts = new String[]{"Spring Length", "Spring Strength", "Repulsion Distance", "Repulsion Strength", "Torque Strength", "Friction"};
    private final DrawingEditor editor;
    private Animator animator;
    private GraphLayout graphLayout = null;
    private final JFrame frame;
    private final JScrollBar[] scroller;
    private final JButton startButton;
    private final JButton stopButton;

    public AutomaticLayoutFrame(DrawingEditor editor) {
        this.editor = editor;
        this.frame = new JFrame("Automatic Net Layout");
        if (!GUIProperties.avoidFrameReshape()) {
            this.frame.setSize(600, 200);
        }
        GridBagLayout gridBag = new GridBagLayout();
        this.frame.getContentPane().setLayout(gridBag);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.weighty = 1.0;
        this.scroller = new JScrollBar[buttonTexts.length];
        for (int i = 0; i < buttonTexts.length; ++i) {
            c.gridwidth = 1;
            c.weightx = 0.0;
            JLabel label = new JLabel(buttonTexts[i]);
            label.setPreferredSize(new Dimension(150, 20));
            gridBag.setConstraints(label, c);
            this.frame.getContentPane().add(label);
            c.gridwidth = 0;
            c.weightx = 1.0;
            this.scroller[i] = new JScrollBar(0, 100, 10, 0, 200);
            this.scroller[i].addAdjustmentListener(this);
            this.scroller[i].setPreferredSize(new Dimension(150, 20));
            gridBag.setConstraints(this.scroller[i], c);
            this.frame.getContentPane().add(this.scroller[i]);
        }
        JPanel panel = new JPanel();
        gridBag.setConstraints(panel, c);
        this.frame.getContentPane().add(panel);
        gridBag = new GridBagLayout();
        panel.setLayout(gridBag);
        panel.setPreferredSize(new Dimension(300, 40));
        c = new GridBagConstraints();
        c.weightx = 1.0;
        c.fill = 1;
        c.gridwidth = 1;
        this.startButton = new JButton("Start");
        this.startButton.addActionListener(e -> this.startAnimation());
        gridBag.setConstraints(this.startButton, c);
        panel.add(this.startButton);
        this.stopButton = new JButton("Stop");
        this.stopButton.addActionListener(e -> this.stopAnimation());
        gridBag.setConstraints(this.stopButton, c);
        panel.add(this.stopButton);
        JButton autoButton = new JButton("Random");
        autoButton.addActionListener(e -> this.annealingLayout());
        gridBag.setConstraints(autoButton, c);
        panel.add(autoButton);
        JButton button = new JButton("Close");
        button.addActionListener(e -> {
            this.stopAnimation();
            this.frame.setVisible(false);
            DrawPlugin.getCurrent().getMenuManager().getWindowsMenu().removeFrame((Frame)this.frame);
        });
        c.gridwidth = 0;
        gridBag.setConstraints(button, c);
        panel.add(button);
        this.frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent w) {
                AutomaticLayoutFrame.this.stopAnimation();
                AutomaticLayoutFrame.this.frame.setVisible(false);
                DrawPlugin.getCurrent().getMenuManager().getWindowsMenu().removeFrame((Frame)AutomaticLayoutFrame.this.frame);
            }
        });
        this.frame.pack();
    }

    public Dimension getPreferredSize() {
        return new Dimension(600, 200);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void showFrame() {
        this.startButton.setEnabled(true);
        this.stopButton.setEnabled(false);
        this.frame.setTitle("Automatic Layout");
        this.frame.setVisible(true);
        DrawPlugin.getCurrent().getMenuManager().getWindowsMenu().addFrame(MenuApi.getWindowsCategoryNameTools(), (Frame)this.frame);
    }

    public void stopAnimation() {
        this.startButton.setEnabled(true);
        this.stopButton.setEnabled(false);
        if (this.animator != null) {
            this.animator.end();
            this.animator = null;
        }
    }

    public void startAnimation() {
        this.stopAnimation();
        this.startButton.setEnabled(false);
        this.stopButton.setEnabled(true);
        DrawingView view = this.editor.view();
        Drawing drawing = view.drawing();
        if (drawing instanceof LayoutableDrawing) {
            LayoutableDrawing layoutableDrawing = (LayoutableDrawing)drawing;
            this.frame.setTitle("Automatic Layout - " + drawing.getName());
            UndoRedoApi.prepareUndoSnapshot();
            UndoRedoApi.commitUndoSnapshot();
            this.graphLayout = new GraphLayout();
            layoutableDrawing.fillInGraph(this.graphLayout);
            this.fillInScrollerValues();
            this.animator = new Animator((Animatable)this, view);
            new Thread((Runnable)this.animator).start();
        }
    }

    public void annealingLayout() {
        Drawing drawing = this.editor.view().drawing();
        if (drawing instanceof LayoutableDrawing) {
            LayoutableDrawing layoutableDrawing = (LayoutableDrawing)drawing;
            new AnnealingGraphLayout().annealingLayout(layoutableDrawing);
        }
    }

    public void createLayout(double springLength, double springStrength, double repulsionDistance, double repulsionStrength, double torqueStrength, double friction, long timeInMillis) {
        this.stopAnimation();
        this.startButton.setEnabled(false);
        this.stopButton.setEnabled(true);
        DrawingView view = this.editor.view();
        Drawing drawing = view.drawing();
        if (drawing instanceof LayoutableDrawing) {
            LayoutableDrawing layoutableDrawing = (LayoutableDrawing)drawing;
            UndoRedoApi.prepareUndoSnapshot();
            UndoRedoApi.commitUndoSnapshot();
            this.graphLayout = new GraphLayout();
            layoutableDrawing.fillInGraph(this.graphLayout);
            this.fillInScrollerValues();
            this.animator = new Animator((Animatable)this, view);
            new Thread((Runnable)this.animator).start();
            this.graphLayout.lengthFactor = 4.0 * springLength;
            this.graphLayout.springStrength = 0.2 * springStrength;
            this.graphLayout.repulsionLimit = 1600.0 * repulsionDistance;
            this.graphLayout.repulsionStrength = 8.0 * repulsionStrength;
            this.graphLayout.torqueStrength = 1.0 * torqueStrength;
            this.graphLayout.frictionFactor = 1.0 - friction;
            if (timeInMillis <= 0L) {
                this.frame.setTitle("Automatic Layout - " + drawing.getName());
                this.frame.setVisible(true);
                DrawPlugin.getCurrent().getMenuManager().getWindowsMenu().addFrame(MenuApi.getWindowsCategoryNameTools(), (Frame)this.frame);
            } else {
                try {
                    Thread.sleep(timeInMillis);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.stopAnimation();
        }
    }

    private static double calcFactor(int value) {
        double n = (double)value / 200.0;
        return n * n;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.fillInScrollerValues();
    }

    private void fillInScrollerValues() {
        int num = 0;
        if (this.graphLayout != null) {
            this.graphLayout.lengthFactor = 4.0 * AutomaticLayoutFrame.calcFactor(this.scroller[num++].getValue());
            this.graphLayout.springStrength = 0.2 * AutomaticLayoutFrame.calcFactor(this.scroller[num++].getValue());
            this.graphLayout.repulsionLimit = 1600.0 * AutomaticLayoutFrame.calcFactor(this.scroller[num++].getValue());
            this.graphLayout.repulsionStrength = 8.0 * AutomaticLayoutFrame.calcFactor(this.scroller[num++].getValue());
            this.graphLayout.torqueStrength = 1.0 * AutomaticLayoutFrame.calcFactor(this.scroller[num++].getValue());
            this.graphLayout.frictionFactor = 1.0 - AutomaticLayoutFrame.calcFactor(this.scroller[num].getValue());
        }
    }

    public synchronized void animationStart() {
    }

    public synchronized void animationStop() {
        this.graphLayout.remove();
        this.graphLayout = null;
    }

    public synchronized void animationStep() {
        if (this.graphLayout != null) {
            this.graphLayout.relax();
        }
    }
}

