/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.framework.FigureWithID;
import CH.ifa.draw.standard.StandardDrawing;
import de.renew.database.TransactionSource;
import de.renew.draw.storables.api.StorableApi;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.DrawingChangeEvent;
import de.renew.draw.storables.ontology.DrawingChangeListener;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureChangeEvent;
import de.renew.draw.storables.ontology.StorableOutput;
import de.renew.draw.ui.ontology.FigureDrawingContext;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.FigureWithHighlight;
import de.renew.gui.InstanceDrawing;
import de.renew.gui.InstanceDrawingFactory;
import de.renew.gui.InstanceFigure;
import de.renew.gui.ModeReplacement;
import de.renew.gui.NetInstanceElementLookup;
import de.renew.gui.PlaceFigure;
import de.renew.gui.SimulableFigure;
import de.renew.net.NetInstance;
import de.renew.remote.NetInstanceAccessor;
import de.renew.remote.NetInstanceAccessorImpl;
import de.renew.remote.ObjectAccessor;
import de.renew.util.StringUtil;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.File;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;

public class CPNInstanceDrawing
extends StandardDrawing
implements DrawingChangeListener,
FigureDrawingContext,
InstanceDrawing {
    private static final Logger logger = Logger.getLogger(CPNInstanceDrawing.class);
    public static final String ID_MACRO = "$ID";
    protected static final Hashtable<String, InstanceDrawing> drawingsByInstance = new Hashtable();
    private static final HashMap<Class<?>, InstanceDrawingFactory> instanceDrawingFactories = new HashMap();
    protected NetInstanceAccessor netInstance;
    private final CPNDrawing cpnDrawing;
    protected Hashtable<FigureWithID, Figure> instanceLookup;

    public CPNInstanceDrawing(NetInstanceAccessor netInstance, CPNDrawing drawing) throws RemoteException {
        this.cpnDrawing = drawing;
        this.connect(netInstance);
        this.cpnDrawing.addDrawingChangeListener(this);
    }

    public NetInstanceAccessor getNetInstance() {
        return this.netInstance;
    }

    public Rectangle displayBox() {
        return super.displayBox().union(this.cpnDrawing.displayBox());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InstanceDrawing getInstanceDrawing(NetInstanceAccessor netInstance) throws RemoteException {
        Hashtable<String, InstanceDrawing> hashtable = drawingsByInstance;
        synchronized (hashtable) {
            String key = netInstance.getNet().getName() + ":" + netInstance.getID();
            if (drawingsByInstance.containsKey(key)) {
                return drawingsByInstance.get(key);
            }
            CPNDrawing drawing = ModeReplacement.getInstance().getDrawingLoader().getDrawing(netInstance.getNet().getName());
            if (drawing != null) {
                InstanceDrawing d = null;
                InstanceDrawingFactory idf = instanceDrawingFactories.get(drawing.getClass());
                if (idf != null) {
                    d = idf.getInstanceDrawing(netInstance, drawing);
                }
                if (d == null) {
                    d = new CPNInstanceDrawing(netInstance, drawing);
                }
                return d;
            }
            String msg = "Cannot display net instance \"" + netInstance.asString() + "\": net drawing not found.";
            logger.error((Object)msg);
            JOptionPane.showMessageDialog(null, msg + "\nPlease load the net drawing and try again.", "Renew", 0);
            return null;
        }
    }

    public static Enumeration<InstanceDrawing> getDependentInstanceDrawings(CPNDrawing baseDrawing) {
        Enumeration<InstanceDrawing> allDrawings = drawingsByInstance.elements();
        ArrayList<InstanceDrawing> dependentDrawings = new ArrayList<InstanceDrawing>();
        while (allDrawings.hasMoreElements()) {
            InstanceDrawing oneDrawing = allDrawings.nextElement();
            if (oneDrawing.getCpnDrawing() != baseDrawing) continue;
            dependentDrawings.add(oneDrawing);
        }
        if (!dependentDrawings.isEmpty()) {
            return Collections.enumeration(dependentDrawings);
        }
        return null;
    }

    @Override
    public CPNDrawing getCpnDrawing() {
        return this.cpnDrawing;
    }

    public void draw(Graphics g) {
        this.drawTemplateFigures(g);
        this.drawInstanceFigures(g);
    }

    protected void drawTemplateFigures(Graphics g) {
        this.cpnDrawing.draw(g, this);
    }

    protected void drawInstanceFigures(Graphics g) {
        super.draw(g);
    }

    @Override
    public InstanceFigure getInstanceFigure(Figure fig) {
        try {
            return (InstanceFigure)this.instanceLookup.get(fig);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public InstanceFigure getInstanceFigureOfFigureWithID(int id) {
        FigureWithID baseFigure = this.cpnDrawing.getFigureWithID(id);
        if (baseFigure != null) {
            return this.getInstanceFigure((Figure)baseFigure);
        }
        return null;
    }

    private boolean isEmphasized(Figure fig) {
        InstanceFigure instFig;
        FigureWithHighlight node = this.cpnDrawing.getFigureForHighlight((Figure)fig);
        if (node != null) {
            fig = node;
        }
        if ((instFig = this.getInstanceFigure((Figure)fig)) != null) {
            return instFig.isHighlighted();
        }
        return false;
    }

    @Override
    public boolean isLocal() {
        return this.netInstance instanceof NetInstanceAccessorImpl;
    }

    public boolean isHighlighted(Figure fig) {
        return fig.isVisible() && this.isEmphasized(fig);
    }

    public boolean isVisible(Figure fig) {
        return !(!fig.isVisible() && !this.isEmphasized(fig) || fig instanceof CPNTextFigure && ((CPNTextFigure)fig).getType() == 1 && ((CPNTextFigure)fig).parent() instanceof PlaceFigure || fig == this.cpnDrawing.getIconFigure());
    }

    public String expandMacro(String text) {
        return CPNInstanceDrawing.expandMacro(text, this.netInstance);
    }

    public static String expandMacro(String text, NetInstanceAccessor instance) {
        try {
            return StringUtil.replace((String)text, (String)ID_MACRO, (String)instance.getID());
        }
        catch (RemoteException e) {
            return e.toString();
        }
    }

    @Override
    public void connect(NetInstanceAccessor netInstance) throws RemoteException {
        if (netInstance == null) {
            return;
        }
        String key = netInstance.getNet().getName() + ":" + netInstance.getID();
        if (this.netInstance != null) {
            drawingsByInstance.remove(key);
            this.notifyTransactionStrategyAboutRelease();
        }
        this.netInstance = netInstance;
        drawingsByInstance.put(key, this);
        this.notifyTransactionStrategyAboutConnect();
        this.setName(netInstance.asString());
        this.instanceLookup = new Hashtable();
        this.createInstanceFigures(netInstance);
    }

    protected void createInstanceFigures(NetInstanceAccessor netInstance) throws RemoteException {
        NetInstanceElementLookup netElementLookup = new NetInstanceElementLookup(netInstance);
        Enumeration<Figure> figures = netElementLookup.getFigures();
        while (figures.hasMoreElements()) {
            FigureWithID figure = (FigureWithID)figures.nextElement();
            Hashtable<Serializable, ObjectAccessor> netElements = netElementLookup.getNetElements(figure);
            if (netElements == null || !(figure instanceof SimulableFigure)) continue;
            SimulableFigure simulableFigure = (SimulableFigure)figure;
            InstanceFigure instanceFigure = simulableFigure.createInstanceFigure(this, netElements);
            this.instanceLookup.put(figure, instanceFigure);
            this.add(instanceFigure);
            this.sendToBack(instanceFigure);
        }
    }

    public static void registerInstanceDrawingFactory(Class<?> key, InstanceDrawingFactory factory) {
        instanceDrawingFactories.put(key, factory);
    }

    public static void unregisterInstanceDrawingFactory(Class<?> key) {
        instanceDrawingFactories.remove(key);
    }

    public void release() {
        this.cpnDrawing.removeDrawingChangeListener(this);
        if (this.netInstance != null) {
            try {
                String key = this.netInstance.getNet().getName() + ":" + this.netInstance.getID();
                drawingsByInstance.remove(key);
            }
            catch (RemoteException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                JOptionPane.showMessageDialog(null, "A problem occurred: " + String.valueOf(e) + "\nSee the console for details.", "Renew", 0);
            }
            this.notifyTransactionStrategyAboutRelease();
            this.instanceLookup = null;
            this.netInstance = null;
        }
        super.release();
    }

    protected void notifyTransactionStrategyAboutConnect() {
        try {
            TransactionSource.netInstanceDrawingOpened((String)this.netInstance.getID());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            JOptionPane.showMessageDialog(null, "A problem occurred: " + String.valueOf(e) + "\nSee the console for details.", "Renew", 0);
        }
    }

    protected void notifyTransactionStrategyAboutRelease() {
        try {
            TransactionSource.netInstanceDrawingClosed((String)this.netInstance.getID());
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            JOptionPane.showMessageDialog(null, "A problem occurred: " + String.valueOf(e) + "\nSee the console for details.", "Renew", 0);
        }
    }

    public void drawingInvalidated(DrawingChangeEvent e) {
        DrawingChangeEvent myEvent = StorableApi.createDrawingChangeEvent((Drawing)this, (Rectangle)e.getInvalidatedRectangle());
        Enumeration listeners = this.drawingChangeListeners();
        while (listeners.hasMoreElements()) {
            DrawingChangeListener listener = (DrawingChangeListener)listeners.nextElement();
            listener.drawingInvalidated(myEvent);
            listener.drawingRequestUpdate(myEvent);
        }
    }

    public void drawingRequestUpdate(DrawingChangeEvent e) {
    }

    public void figureRequestRemove(FigureChangeEvent figureChangeEvent) {
        logger.error((Object)"Figures from net instance drawings may not be removed.");
    }

    public boolean isModified() {
        return false;
    }

    public Dimension defaultSize() {
        return this.cpnDrawing.defaultSize();
    }

    public String getWindowCategory() {
        if (this.isLocal()) {
            return "Net instances";
        }
        return "Remote net instances";
    }

    public void lock() {
        this.cpnDrawing.lock();
        super.lock();
    }

    public void unlock() {
        super.unlock();
        this.cpnDrawing.unlock();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        throw new NotSerializableException("CPNInstanceDrawing is not serializable!");
    }

    public static NetInstance[] getAllLocalInstances() {
        ArrayList<NetInstance> saveList = new ArrayList<NetInstance>(drawingsByInstance.size());
        Enumeration<InstanceDrawing> enumeration = drawingsByInstance.elements();
        while (enumeration.hasMoreElements()) {
            InstanceDrawing drawing = enumeration.nextElement();
            if (!drawing.isLocal()) continue;
            NetInstanceAccessorImpl accessor = (NetInstanceAccessorImpl)drawing.getNetInstance();
            saveList.add((NetInstance)accessor.getObject());
        }
        return saveList.toArray(new NetInstance[0]);
    }

    public File getFilename() {
        return this.cpnDrawing.getFilename();
    }

    public boolean isStorable() {
        return false;
    }

    public void write(StorableOutput dw) {
        logger.warn((Object)(CPNInstanceDrawing.class.getSimpleName() + ": CPNInstanceDrawing is not storable."));
    }
}

