/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.figures.TextFigure;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.ui.api.ErrorApi;
import de.renew.draw.ui.ontology.ErrorState;
import de.renew.gui.CPNDrawing;
import de.renew.simulatorontology.shadow.ShadowNetElement;
import de.renew.simulatorontology.shadow.SyntaxException;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FigureExceptionFactory {
    private static final Logger logger = Logger.getLogger(FigureExceptionFactory.class);

    public static ErrorState createFigureException(SyntaxException e, Drawing errorDrawing, TextFigure textErrorFigure) {
        int line = e.getLine();
        int column = e.getColumn();
        String message = e.getMessage();
        Object o = e.getProblemSpecificInformation();
        logger.debug((Object)"Syntax Error: ", (Throwable)e);
        return ErrorApi.createErrorState((String)message, (int)line, (int)column, (Drawing)errorDrawing, (Figure)textErrorFigure, (Object)o);
    }

    public static ErrorState createFigureException(SyntaxException e) {
        CPNDrawing errorDrawing;
        int line = e.getLine();
        int column = e.getColumn();
        String message = e.getMessage();
        Object o = e.getProblemSpecificInformation();
        TextFigure textErrorFigure = null;
        Vector<Figure> errorFigures = new Vector<Figure>();
        if (!e.getErrorObjects().isEmpty()) {
            errorDrawing = CPNDrawing.findDrawing(e.getErrorObjects().elementAt(0));
            if (errorDrawing != null) {
                boolean errorFound = false;
                Enumeration errorObjects = e.getErrorObjects().elements();
                while (errorObjects.hasMoreElements()) {
                    Object errorObject = errorObjects.nextElement();
                    Figure errorFigure = null;
                    if (errorObject instanceof ShadowNetElement) {
                        errorFigure = (Figure)((ShadowNetElement)errorObject).getContext();
                    }
                    if (errorFigure == null) continue;
                    if (errorFound) {
                        textErrorFigure = null;
                    } else {
                        TextFigure textFigure;
                        errorFound = true;
                        if (e.getLine() > 0 && e.getColumn() > 0 && errorFigure instanceof TextFigure && (textFigure = (TextFigure)errorFigure).acceptsTyping()) {
                            textErrorFigure = textFigure;
                        }
                    }
                    errorFigures.addElement(errorFigure);
                }
            }
        } else {
            errorDrawing = null;
        }
        logger.debug((Object)"Syntax Error: ", (Throwable)e);
        return ErrorApi.createErrorState((String)message, (int)line, (int)column, (Drawing)errorDrawing, textErrorFigure, errorFigures, (Object)o);
    }
}

