/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.gui.SimpleCompositeFigure;
import java.awt.Dimension;
import java.awt.Point;

public class HorizontalCompositeFigure
extends SimpleCompositeFigure {
    protected HorizontalCompositeFigure() {
    }

    public HorizontalCompositeFigure(Figure fig) {
        this.add(fig);
        this.layout();
    }

    @Override
    protected void layout() {
        Dimension extent = this.calcExtent();
        this.fDisplayBox.width = extent.width;
        this.fDisplayBox.height = extent.height;
        FigureEnumeration figenumeration = this.figures();
        Point location = this.fDisplayBox.getLocation();
        while (figenumeration.hasMoreElements()) {
            Figure figure = (Figure)figenumeration.nextElement();
            Dimension figureDim = figure.size();
            location.y = this.fDisplayBox.y + Math.max(0, (this.fDisplayBox.height - figureDim.height) / 2);
            Point corner = new Point(location.x + figureDim.width, location.y + figureDim.height);
            figure.basicDisplayBox(location, corner);
            location.x += figureDim.width;
        }
        super.layout();
    }

    @Override
    protected boolean needsLayout() {
        return !this.size().equals(this.calcExtent());
    }

    private Dimension calcExtent() {
        FigureEnumeration figenumeration = this.figures();
        Dimension extent = new Dimension(0, 0);
        while (figenumeration.hasMoreElements()) {
            Figure figure = (Figure)figenumeration.nextElement();
            Dimension figureDim = figure.size();
            extent.width += figureDim.width;
            extent.height = Math.max(extent.height, figureDim.height);
        }
        return extent;
    }
}

