/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.IOHelper;
import CH.ifa.draw.io.DrawingFileHelper;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.gui.CPNDrawing;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import java.awt.EventQueue;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class LoadFileFromJarHelper {
    private static final Logger logger = Logger.getLogger(LoadFileFromJarHelper.class);
    private static final String RNW_IMG_PROPERTY = "de.renew.jars.containing.rnw.files";
    private static String extensionUsed;

    public static synchronized BufferedInputStream getImageFromJar(String fileName, String ... extensions) {
        try {
            logger.trace((Object)("LoadFileFromJarHelper.getImageFromJar: FILENAME " + fileName));
            extensionUsed = null;
            JarFile jarFile = LoadFileFromJarHelper.getJarFileContainingFile(fileName, extensions);
            if (jarFile == null) {
                logger.warn((Object)("1. Image with name " + fileName + " not found"));
                return null;
            }
            ZipEntry entry = jarFile.getEntry(fileName + "." + extensionUsed);
            if (entry == null) {
                logger.warn((Object)("2. Image with name " + fileName + " not found"));
                return null;
            }
            InputStream stream = jarFile.getInputStream(entry);
            return new BufferedInputStream(stream);
        }
        catch (IOException | NullPointerException e) {
            logger.warn((Object)e.getMessage());
            return null;
        }
    }

    public static synchronized void loadRnwFileFromJar(String name) {
        IOHelper ioHelper;
        extensionUsed = null;
        Drawing newDrawing = null;
        JarFile jarFile = null;
        if (name != null && name.endsWith(".rnw")) {
            name = name.replace(".rnw", "");
        }
        try {
            jarFile = LoadFileFromJarHelper.getJarFileContainingFile(name, "rnw");
            ZipEntry entry = jarFile.getEntry(name + ".rnw");
            InputStream stream = jarFile.getInputStream(entry);
            newDrawing = DrawingFileHelper.loadDrawing((InputStream)stream, (String)name);
        }
        catch (Exception e) {
            logger.error((Object)("Failed to load drawing " + name), (Throwable)e);
        }
        if (newDrawing != null && newDrawing instanceof CPNDrawing && (ioHelper = DrawPlugin.getCurrent().getIOHelper()) != null && jarFile != null) {
            ZipEntry entry = jarFile.getEntry(name + ".rnw");
            InputStream tmp = null;
            try {
                tmp = jarFile.getInputStream(entry);
            }
            catch (IOException e) {
                logger.error((Object)("Failed to get InputStream for " + name + ".rnw from jar file"), (Throwable)e);
            }
            InputStream fstream = tmp;
            String fName = name;
            if (SwingUtilities.isEventDispatchThread()) {
                try {
                    ioHelper.loadAndOpenDrawings(fstream, fName);
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    EventQueue.invokeAndWait(() -> {
                        try {
                            ioHelper.loadAndOpenDrawings(fstream, fName);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    });
                }
                catch (InterruptedException e) {
                    logger.trace((Object)"HelperGui.test : Caught interrupt while loading drawing", (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    logger.trace((Object)"HelperGui.test : Caught InvocationTargetException while loading drawing", (Throwable)e);
                }
            }
        }
    }

    private static synchronized File findJarFile(String pluginName) {
        IPlugin plugin = PluginManager.getInstance().getPluginByName(pluginName);
        if (plugin != null) {
            try {
                logger.debug((Object)("FOUND jar file for pluginName " + pluginName));
                return new File(plugin.getProperties().getURL().toURI());
            }
            catch (URISyntaxException e) {
                logger.error((Object)("Error while creating File for plugin " + pluginName + " of URL " + String.valueOf(plugin.getProperties().getURL())), (Throwable)e);
            }
        }
        logger.warn((Object)("No plugin found with name " + pluginName));
        return null;
    }

    private static synchronized JarFile getJarFileContainingFile(String filename, String ... extensions) throws FileNotFoundException, IOException {
        if (extensions == null || extensions.length == 0) {
            throw new NullPointerException("No extension(s) given");
        }
        String property = PluginProperties.getUserProperties().getProperty(RNW_IMG_PROPERTY);
        if (property == null) {
            logger.warn((Object)"Property de.renew.jars.containing.rnw.files not set!");
            return null;
        }
        String[] pluginNames = property.split(":");
        if (pluginNames == null || pluginNames.length == 0) {
            return null;
        }
        for (String pluginName : pluginNames) {
            File jarFile = LoadFileFromJarHelper.findJarFile(pluginName);
            if (jarFile == null) continue;
            JarFile jarRes = new JarFile(jarFile);
            ZipEntry entry = null;
            for (String extension : extensions) {
                entry = jarRes.getEntry(filename + "." + extension);
                if (entry == null) continue;
                extensionUsed = extension;
                break;
            }
            if (entry == null) continue;
            logger.debug((Object)("Found ZIPEntry which contains file " + filename));
            return jarRes;
        }
        throw new FileNotFoundException("File " + filename + " not found in any of the given plugins " + property);
    }
}

