/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui;

import de.renew.formalism.FormalismPlugin;
import de.renew.gui.CPNDrawing;
import de.renew.gui.FigureExceptionFactory;
import de.renew.gui.GuiPlugin;
import de.renew.shadowcompiler.ShadowCompilerFactory;
import de.renew.shadowcompiler.ShadowNetSystemCreator;
import de.renew.simulator.api.SimulationManager;
import de.renew.simulatorontology.shadow.ShadowNetSystem;
import de.renew.simulatorontology.shadow.SyntaxException;
import de.renew.simulatorontology.simulation.NoSimulationException;
import java.awt.EventQueue;
import org.apache.log4j.Logger;

public class NetInstanceBuilder {
    private static final Logger logger = Logger.getLogger(NetInstanceBuilder.class);

    public static void buildInstanceFromDrawing(CPNDrawing cpnd) {
        NetInstanceBuilder.buildInstanceFromDrawing(cpnd, FormalismPlugin.getCurrent().getCompiler());
    }

    public static void buildInstanceFromDrawing(CPNDrawing cpnd, String formalismName) {
        FormalismPlugin fp = FormalismPlugin.getCurrent();
        NetInstanceBuilder.buildInstanceFromDrawing(cpnd, fp.getCompilerFactoryByName(formalismName));
    }

    public static void buildInstanceFromDrawing(CPNDrawing cpnd, ShadowCompilerFactory compilerFactory) {
        if (!cpnd.getName().equals("untitled")) {
            ShadowNetSystem sns = ShadowNetSystemCreator.createWithCompiler((ShadowCompilerFactory)compilerFactory);
            cpnd.buildShadow(sns);
            try {
                SimulationManager.addShadowNetSystem((ShadowNetSystem)sns);
            }
            catch (NoSimulationException e) {
                logger.error((Object)"Simulation was terminated befor the new net has been initialized");
            }
            catch (SyntaxException e) {
                EventQueue.invokeLater(() -> GuiPlugin.getCurrent().processSyntaxException(FigureExceptionFactory.createFigureException(e), true));
            }
        }
    }
}

