/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.configure;

import de.renew.gui.ConfigureSimulationTabController;
import de.renew.gui.configure.ConfigureRemoteAccessTab;
import de.renew.plugin.PropertyHelper;
import de.renew.remote.RemoteExtension;
import java.awt.Component;
import java.util.Properties;
import org.apache.log4j.Logger;

public class ConfigureRemoteAccessController
implements ConfigureSimulationTabController {
    private static final Logger logger = Logger.getLogger(ConfigureRemoteAccessController.class);
    private final ConfigureRemoteAccessTab tab = new ConfigureRemoteAccessTab();

    public ConfigureRemoteAccessController() {
        this.tab.addEnabledStateListener(e -> this.enabledStateChanged());
    }

    @Override
    public Component getTab() {
        return this.tab;
    }

    @Override
    public void commitTab(Properties props) {
        boolean enabled = this.tab.getRemoteEnabled();
        props.setProperty("de.renew.remote.enable", Boolean.toString(enabled));
        String publicName = this.tab.getPublicName().trim();
        if (publicName.isEmpty() || publicName.equals("default")) {
            props.remove("de.renew.remote.publicName");
            publicName = null;
        } else {
            props.setProperty("de.renew.remote.publicName", publicName);
        }
        String className = this.tab.getServerClass().trim();
        if (className.isEmpty() || className.equals(RemoteExtension.DEFAULT_SERVER_CLASS.getName())) {
            props.remove("de.renew.remote.serverClass");
            className = null;
        } else {
            props.setProperty("de.renew.remote.serverClass", className);
        }
        logger.debug((Object)("ConfigureRemoteAccessController: Configured enabled=" + enabled + ", name=" + publicName + ", class=" + className + "."));
    }

    @Override
    public void updateTab(Properties props) {
        this.tab.setRemoteEnabled(PropertyHelper.getBoolProperty((Properties)props, (String)"de.renew.remote.enable"));
        String className = props.getProperty("de.renew.remote.serverClass");
        if (className == null) {
            className = RemoteExtension.DEFAULT_SERVER_CLASS.getName();
        }
        this.tab.setServerClass(className);
        String publicName = props.getProperty("de.renew.remote.publicName");
        if (publicName == null) {
            publicName = "default";
        }
        this.tab.setPublicName(publicName);
        String factoryName = props.getProperty("de.renew.remote.socketFactory");
        if (factoryName == null) {
            factoryName = "";
        }
        this.tab.setSocketFactory(factoryName);
        this.enabledStateChanged();
    }

    public void enabledStateChanged() {
        this.tab.enableDetailOptions(this.tab.getRemoteEnabled());
    }
}

