/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.pnml.creator;

import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.gui.ArcConnection;
import de.renew.gui.CPNDrawing;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.DeclarationFigure;
import de.renew.gui.PlaceFigure;
import de.renew.gui.TransitionFigure;
import de.renew.gui.VirtualPlaceFigure;
import de.renew.gui.VirtualTransitionFigure;
import de.renew.gui.pnml.converter.Converter;
import de.renew.gui.pnml.creator.ArcCreator;
import de.renew.gui.pnml.creator.AttributeCreator;
import de.renew.gui.pnml.creator.ElementCreator;
import de.renew.gui.pnml.creator.NodeCreator;
import de.renew.gui.pnml.creator.PNMLCreator;
import de.renew.gui.pnml.creator.PlaceCreator;
import de.renew.gui.pnml.creator.TransitionCreator;
import de.renew.gui.pnml.creator.VirtualPlaceCreator;
import de.renew.gui.pnml.creator.VirtualTransitionCreator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;

public class NetCreator
extends ElementCreator {
    private static final Logger logger = Logger.getLogger(NetCreator.class);
    private final List<PlaceFigure> placeList = new ArrayList<PlaceFigure>();

    public NetCreator(String netType, boolean toolInsc) {
        super("net", new Converter(netType, toolInsc));
    }

    private void connectNewStart(VirtualPlaceFigure virPlace, ArcConnection arc) {
        while (virPlace.getSemanticFigure() instanceof VirtualPlaceFigure) {
            virPlace = (VirtualPlaceFigure)virPlace.getSemanticFigure();
        }
        PlaceFigure figure = virPlace.getSemanticFigure();
        arc.disconnectStart();
        arc.connectStart(figure.connectorAt(figure.center()));
    }

    private void connectNewStart(VirtualTransitionFigure virTransition, ArcConnection arc) {
        while (virTransition.getSemanticFigure() instanceof VirtualTransitionFigure) {
            virTransition = (VirtualTransitionFigure)virTransition.getSemanticFigure();
        }
        TransitionFigure figure = virTransition.getSemanticFigure();
        arc.disconnectStart();
        arc.connectStart(figure.connectorAt(figure.center()));
    }

    private void connectNewEnd(VirtualPlaceFigure virPlace, ArcConnection arc) {
        while (virPlace.getSemanticFigure() instanceof VirtualPlaceFigure) {
            virPlace = (VirtualPlaceFigure)virPlace.getSemanticFigure();
        }
        PlaceFigure figure = virPlace.getSemanticFigure();
        arc.disconnectEnd();
        arc.connectEnd(figure.connectorAt(figure.center()));
    }

    private void connectNewEnd(VirtualTransitionFigure virTransition, ArcConnection arc) {
        while (virTransition.getSemanticFigure() instanceof VirtualTransitionFigure) {
            virTransition = (VirtualTransitionFigure)virTransition.getSemanticFigure();
        }
        TransitionFigure figure = virTransition.getSemanticFigure();
        arc.disconnectEnd();
        arc.connectEnd(figure.connectorAt(figure.center()));
    }

    @Override
    protected Element doCreateElement(PNMLCreator pnmlCreator) {
        Figure figure;
        Element pageEle;
        Element netEle = super.doCreateElement(pnmlCreator);
        CPNDrawing net = (CPNDrawing)this.getObject();
        Converter converter = this.getConverter();
        converter.setShadowNet(net);
        String netID = converter.getNetID();
        String netType = converter.getType();
        netEle.setAttribute("id", "net_" + netID);
        netEle.setAttribute("type", netType);
        AttributeCreator name = new AttributeCreator(pnmlCreator, "name");
        netEle.appendChild(name.createElement(net.getName()));
        if (converter.getNetConverter().createPageTag()) {
            pageEle = pnmlCreator.createElement("page");
            pageEle.setAttribute("id", "page_" + netID);
            netEle.appendChild(pageEle);
        } else {
            pageEle = netEle;
        }
        FigureEnumeration figures = net.figures();
        HashMap virtualPlaceAnnotations = new HashMap();
        HashMap<Integer, List<Figure>> virtualTransitionAnnotations = new HashMap<Integer, List<Figure>>();
        while (figures.hasMoreElements()) {
            Figure nextFig;
            FigureEnumeration figureenu;
            List<Figure> annos;
            Integer orgid;
            Element toolSpec;
            NodeCreator virCreator;
            figure = (Figure)figures.nextElement();
            if (figure instanceof VirtualPlaceFigure) {
                VirtualPlaceFigure virPlace = (VirtualPlaceFigure)figure;
                virCreator = new VirtualPlaceCreator(converter);
                toolSpec = pnmlCreator.createToolspecific();
                toolSpec.appendChild(virCreator.createElement(pnmlCreator, virPlace));
                pageEle.appendChild(toolSpec);
                orgid = virPlace.getSemanticFigure().getID();
                if (virtualPlaceAnnotations.containsKey(orgid)) {
                    annos = (List)virtualPlaceAnnotations.get(orgid);
                } else {
                    annos = new ArrayList();
                    virtualPlaceAnnotations.put(orgid, annos);
                }
                figureenu = virPlace.children();
                while (figureenu.hasMoreElements()) {
                    nextFig = figureenu.nextFigure();
                    annos.add(nextFig);
                }
                continue;
            }
            if (!(figure instanceof VirtualTransitionFigure)) continue;
            VirtualTransitionFigure virTransition = (VirtualTransitionFigure)figure;
            virCreator = new VirtualTransitionCreator(converter);
            toolSpec = pnmlCreator.createToolspecific();
            toolSpec.appendChild(virCreator.createElement(pnmlCreator, virTransition));
            pageEle.appendChild(toolSpec);
            orgid = virTransition.getSemanticFigure().getID();
            if (virtualTransitionAnnotations.containsKey(orgid)) {
                annos = (List)virtualTransitionAnnotations.get(orgid);
            } else {
                annos = new ArrayList();
                virtualTransitionAnnotations.put(orgid, annos);
            }
            figureenu = virTransition.children();
            while (figureenu.hasMoreElements()) {
                nextFig = figureenu.nextFigure();
                annos.add(nextFig);
            }
        }
        figures = net.figures();
        while (figures.hasMoreElements()) {
            List virtAnnos;
            figure = (Figure)figures.nextElement();
            if (figure instanceof PlaceFigure) {
                PlaceFigure place = (PlaceFigure)figure;
                if (!(figure instanceof VirtualPlaceFigure)) {
                    PlaceCreator placeCreator = new PlaceCreator(converter);
                    this.placeList.add(place);
                    Element pnmlPlace = placeCreator.createElement(pnmlCreator, figure);
                    virtAnnos = (List)virtualPlaceAnnotations.get(place.getID());
                    if (virtAnnos != null) {
                        for (Figure fig : virtAnnos) {
                            pnmlPlace.appendChild(this.getNetConverter().annotationToPNML((CPNTextFigure)fig, pnmlCreator, true));
                        }
                    }
                    pageEle.appendChild(pnmlPlace);
                    continue;
                }
            }
            if (figure instanceof TransitionFigure) {
                TransitionFigure transition = (TransitionFigure)figure;
                if (!(figure instanceof VirtualTransitionFigure)) {
                    TransitionCreator transitionCreator = new TransitionCreator(converter);
                    Element pnmlTransition = transitionCreator.createElement(pnmlCreator, figure);
                    virtAnnos = (List)virtualTransitionAnnotations.get(transition.getID());
                    if (virtAnnos != null) {
                        for (Figure fig : virtAnnos) {
                            pnmlTransition.appendChild(this.getNetConverter().annotationToPNML((CPNTextFigure)fig, pnmlCreator, true));
                        }
                    }
                    pageEle.appendChild(pnmlTransition);
                    continue;
                }
            }
            if (figure instanceof ArcConnection) {
                VirtualTransitionFigure virTransition;
                VirtualPlaceFigure virPlace;
                ArcConnection arc = (ArcConnection)figure;
                Figure sourceFigure = arc.startFigure();
                Figure targetFigure = arc.endFigure();
                ArcCreator arcCreator = new ArcCreator(this.getConverter());
                if (sourceFigure instanceof VirtualPlaceFigure) {
                    virPlace = (VirtualPlaceFigure)sourceFigure;
                    this.connectNewStart(virPlace, arc);
                    arcCreator.setVirStart(virPlace);
                } else if (sourceFigure instanceof VirtualTransitionFigure) {
                    virTransition = (VirtualTransitionFigure)sourceFigure;
                    this.connectNewStart(virTransition, arc);
                    arcCreator.setVirStart(virTransition);
                }
                if (targetFigure instanceof VirtualPlaceFigure) {
                    virPlace = (VirtualPlaceFigure)targetFigure;
                    this.connectNewEnd(virPlace, arc);
                    arcCreator.setVirEnd(virPlace);
                } else if (targetFigure instanceof VirtualTransitionFigure) {
                    virTransition = (VirtualTransitionFigure)targetFigure;
                    this.connectNewEnd(virTransition, arc);
                    arcCreator.setVirEnd(virTransition);
                }
                pageEle.appendChild(arcCreator.createElement(pnmlCreator, figure));
                arc.disconnectStart();
                arc.connectStart(sourceFigure.connectorAt(sourceFigure.center()));
                arc.disconnectEnd();
                arc.connectEnd(targetFigure.connectorAt(targetFigure.center()));
                continue;
            }
            if (figure instanceof DeclarationFigure) {
                pageEle.appendChild(converter.getNetConverter().annotationToPNML((DeclarationFigure)figure, pnmlCreator, false));
                continue;
            }
            if (!(figure instanceof CPNTextFigure) || ((CPNTextFigure)figure).parent() != null) continue;
            logger.error((Object)("NetCreator: Unknown type -> " + String.valueOf(figure.getClass())));
        }
        return netEle;
    }

    List<PlaceFigure> getPlaceList() {
        return this.placeList;
    }
}

