/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.tool;

import CH.ifa.draw.standard.CreationTool;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.ui.ontology.DrawingEditor;
import de.renew.gui.CPNTextFigure;
import de.renew.gui.PlaceFigure;
import de.renew.gui.VirtualPlaceFigure;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class VirtualPlaceFigureCreationTool
extends CreationTool {
    private VirtualPlaceFigure virtualPlace = null;

    public VirtualPlaceFigureCreationTool(DrawingEditor editor) {
        super(editor);
    }

    protected Figure createFigure() {
        return new VirtualPlaceFigure(null);
    }

    public void mouseMove(MouseEvent e, int x, int y) {
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        Figure fTarget = this.drawing().findFigure(x, y);
        if (fTarget instanceof PlaceFigure) {
            PlaceFigure semanticPlaceFigure = (PlaceFigure)fTarget;
            while (semanticPlaceFigure instanceof VirtualPlaceFigure) {
                VirtualPlaceFigure virtualPlaceFigure = (VirtualPlaceFigure)semanticPlaceFigure;
                semanticPlaceFigure = virtualPlaceFigure.getSemanticFigure();
            }
            this.virtualPlace = new VirtualPlaceFigure(semanticPlaceFigure);
            this.view().add((Figure)this.virtualPlace);
            FigureEnumeration children = ((PlaceFigure)fTarget).children();
            Rectangle r = fTarget.displayBox();
            while (children.hasMoreElements()) {
                CPNTextFigure textFig;
                Figure nextFigure = children.nextFigure();
                if (!(nextFigure instanceof CPNTextFigure) || (textFig = (CPNTextFigure)nextFigure).getType() != 2) continue;
                CPNTextFigure virtualPlaceName = new CPNTextFigure(2);
                virtualPlaceName.setText(textFig.getText());
                this.view().add((Figure)virtualPlaceName);
                virtualPlaceName.setParent(this.virtualPlace);
                int xDistance = textFig.displayBox().x - r.x;
                int yDistance = textFig.displayBox().y - r.y;
                virtualPlaceName.moveBy(xDistance, yDistance);
            }
            this.virtualPlace.displayBox(new Rectangle(r.x, r.y, r.width, r.height));
            this.changesMade();
        }
    }

    public void mouseDrag(MouseEvent e, int x, int y) {
        if (this.virtualPlace != null) {
            Rectangle r = this.virtualPlace.displayBox();
            this.virtualPlace.displayBox(new Rectangle(x - r.width / 2, y - r.height / 2, r.width, r.height));
        }
    }

    public void mouseUp(MouseEvent e, int x, int y) {
        this.virtualPlace = null;
        this.editor().toolDone();
    }

    public void deactivate() {
        super.deactivate();
        this.virtualPlace = null;
    }
}

