/*
 * Decompiled with CFR 0.152.
 */
package de.renew.io.exportFormats;

import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.exporting.AbstractDrawingExportFormat;
import de.renew.gui.CPNDrawing;
import de.renew.gui.ModeReplacement;
import de.renew.io.FileFilterCreator;
import de.renew.ioontology.FileFilter;
import de.renew.shadowcompiler.ShadowCompilerFactory;
import de.renew.shadowcompiler.ShadowNetSystemCreator;
import de.renew.simulatorontology.shadow.ShadowNetSystem;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;

public class SNSExportFormat
extends AbstractDrawingExportFormat {
    public SNSExportFormat() {
        super("ShadowNetSystem", (FileFilter)FileFilterCreator.createSNSFileFilter());
    }

    public boolean canExportNto1() {
        return true;
    }

    public File export(Drawing drawing, File path) throws Exception {
        File result = null;
        if (drawing != null && path != null) {
            result = path;
            FileOutputStream stream = new FileOutputStream(result);
            ObjectOutputStream output = new ObjectOutputStream(stream);
            ShadowNetSystem netSystem = ShadowNetSystemCreator.createWithCompiler((ShadowCompilerFactory)ModeReplacement.getInstance().getDefaultCompilerFactory());
            CPNDrawing cpndrawing = (CPNDrawing)drawing;
            cpndrawing.buildShadow(netSystem);
            output.writeObject(netSystem);
            output.close();
        }
        assert (result != null) : "Failure in SNSExportFormat: result == null";
        return result;
    }

    public File export(Drawing[] drawings, File path) throws Exception {
        File result = null;
        if (drawings != null && path != null) {
            result = path;
            FileOutputStream stream = new FileOutputStream(result);
            ObjectOutputStream output = new ObjectOutputStream(stream);
            ShadowNetSystem system = ShadowNetSystemCreator.createWithCompiler((ShadowCompilerFactory)ModeReplacement.getInstance().getDefaultCompilerFactory());
            for (Drawing value : drawings) {
                CPNDrawing drawing = (CPNDrawing)value;
                drawing.buildShadow(system);
            }
            output.writeObject(system);
            output.close();
        }
        assert (result != null) : "Failure in SNSExportFormat: result == null";
        return result;
    }

    public boolean canExportDrawing(Drawing drawing) {
        return drawing instanceof CPNDrawing;
    }
}

