/*
 * Decompiled with CFR 0.152.
 */
package de.renew.gui.fs;

import CH.ifa.draw.DrawPlugin;
import CH.ifa.draw.application.DrawApplication;
import CH.ifa.draw.standard.CompositeFigure;
import CH.ifa.draw.standard.StandardDrawing;
import de.renew.draw.storables.ontology.Drawing;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.draw.ui.ontology.DrawingView;
import de.renew.formalism.FormalismPlugin;
import de.renew.formalism.efsnet.EFSNetCompiler;
import de.renew.formalism.fs.FSNetCompiler;
import de.renew.formalism.fs.FSNetWithoutConceptsCompiler;
import de.renew.formalism.fsnet.XFSNetCompiler;
import de.renew.formalism.gui.FormalismGuiCreator;
import de.renew.formalism.gui.FormalismGuiPlugin;
import de.renew.gui.FigureCreator;
import de.renew.gui.FigureCreatorHolder;
import de.renew.gui.GuiPlugin;
import de.renew.gui.TextFigureCreator;
import de.renew.gui.fs.EFSGuiConfigurator;
import de.renew.gui.fs.FSFigure;
import de.renew.gui.fs.FSGuiConfigurator;
import de.renew.net.NetInstance;
import de.renew.plugin.IPlugin;
import de.renew.plugin.PluginAdapter;
import de.renew.plugin.PluginException;
import de.renew.plugin.PluginManager;
import de.renew.plugin.PluginProperties;
import de.renew.remote.ObjectAccessor;
import de.renew.remote.ObjectAccessorImpl;
import de.renew.shadowcompiler.ShadowCompilerFactory;
import de.renew.util.Value;
import de.uni_hamburg.fs.FeatureStructure;
import java.net.URL;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class FSPlugin
extends PluginAdapter {
    public static final Logger LOGGER = Logger.getLogger(FSPlugin.class);
    public static final String FSNET_COMPILER = "Java+FS Net Compiler (untested)";
    public static final String FSNET_WOC_COMPILER = "Java+FS Net Compiler - No Concepts (untested)";
    public static final String EFSNET_COMPILER = "EFS Net Compiler (untested)";
    public static final String XFSNET_COMPILER = "XFS Net Compiler";
    public static final String UML_RENDER_MODE_PROP = "de.renew.gui.fs.umlMode";
    public static final String FS_EXPERIMENTAL_COMPILERS_PROP = "de.renew.gui.fs.showExperimentalCompilers";
    private FigureCreator _fsFigureCreator = null;
    private TextFigureCreator _fsTextFigureCreator = null;
    private boolean _umlRenderMode;

    public FSPlugin(URL location) throws PluginException {
        super(location);
        this.readInitialRenderMode();
    }

    public FSPlugin(PluginProperties props) {
        super(props);
        this.readInitialRenderMode();
    }

    private void readInitialRenderMode() {
        this._umlRenderMode = this.getProperties().getBoolProperty(UML_RENDER_MODE_PROP);
    }

    public boolean getUmlRenderMode() {
        return this._umlRenderMode;
    }

    public void setUmlRenderMode(boolean newUmlRenderMode) {
        if (this._umlRenderMode != newUmlRenderMode) {
            this._umlRenderMode = newUmlRenderMode;
            this.getProperties().setProperty(UML_RENDER_MODE_PROP, Boolean.toString(this._umlRenderMode));
            DrawApplication editor = DrawPlugin.getGui();
            if (editor != null) {
                Enumeration drawings = editor.drawings();
                while (drawings.hasMoreElements()) {
                    StandardDrawing drawing = (StandardDrawing)drawings.nextElement();
                    boolean changed = this.changeFSFigures((CompositeFigure)drawing);
                    if (!changed) continue;
                    DrawingView view = editor.getView((Drawing)drawing);
                    if (view != null) {
                        view.clearSelection();
                        view.checkDamage();
                    }
                    editor.getUndoRedoManager().clearUndoHistory((Drawing)drawing);
                }
            }
        }
    }

    private boolean changeFSFigures(CompositeFigure figure) {
        boolean changed = false;
        FigureEnumeration figs = figure.figures();
        while (figs.hasMoreElements()) {
            Figure fig = figs.nextFigure();
            if (fig instanceof FSFigure) {
                fig.willChange();
                ((FSFigure)fig).markDirty();
                fig.changed();
                changed = true;
                continue;
            }
            if (!(fig instanceof CompositeFigure)) continue;
            changed |= this.changeFSFigures((CompositeFigure)fig);
        }
        return changed;
    }

    public void init() {
        FigureCreatorHolder fc = GuiPlugin.getCurrent().getFigureCreatorHolder();
        this._fsFigureCreator = new FigureCreator(){

            public boolean canCreateFigure(ObjectAccessor token, boolean expanded) {
                if (token instanceof ObjectAccessorImpl) {
                    Object obj = ((ObjectAccessorImpl)token).getObject();
                    return obj instanceof FeatureStructure || expanded && !(obj instanceof NetInstance) && !(obj instanceof Value) && !(obj instanceof String);
                }
                return false;
            }

            public Figure getTokenFigure(ObjectAccessor token, boolean expanded) {
                assert (token instanceof ObjectAccessorImpl) : "FS-getTokenFigure called with remote token.";
                Object obj = ((ObjectAccessorImpl)token).getObject();
                if (obj instanceof FeatureStructure) {
                    return new FSFigure((FeatureStructure)obj, expanded);
                }
                return new FSFigure(obj);
            }
        };
        fc.registerCreator(this._fsFigureCreator);
        FormalismPlugin.getCurrent().addCompilerFactory(XFSNET_COMPILER, (ShadowCompilerFactory)new XFSNetCompiler());
        FormalismGuiPlugin.getCurrent().addGuiConfigurator(XFSNET_COMPILER, (FormalismGuiCreator)new FSGuiConfigurator());
        if (this.getProperties().getBoolProperty(FS_EXPERIMENTAL_COMPILERS_PROP)) {
            LOGGER.info((Object)"Enabling experimental FSNet compilers.");
            FormalismPlugin.getCurrent().addCompilerFactory(FSNET_COMPILER, (ShadowCompilerFactory)new FSNetCompiler());
            FormalismGuiPlugin.getCurrent().addGuiConfigurator(FSNET_COMPILER, (FormalismGuiCreator)new FSGuiConfigurator());
            FormalismPlugin.getCurrent().addCompilerFactory(FSNET_WOC_COMPILER, (ShadowCompilerFactory)new FSNetWithoutConceptsCompiler());
            FormalismGuiPlugin.getCurrent().addGuiConfigurator(FSNET_WOC_COMPILER, (FormalismGuiCreator)new FSGuiConfigurator());
            FormalismPlugin.getCurrent().addCompilerFactory(EFSNET_COMPILER, (ShadowCompilerFactory)new EFSNetCompiler());
            FormalismGuiPlugin.getCurrent().addGuiConfigurator(EFSNET_COMPILER, (FormalismGuiCreator)new EFSGuiConfigurator());
        } else {
            LOGGER.debug((Object)"Experimental FSNet compilers disabled.");
        }
    }

    public final boolean cleanup() {
        FormalismGuiPlugin.getCurrent().removeGuiConfigurator(FSNET_COMPILER);
        FormalismPlugin.getCurrent().removeCompilerFactory(FSNET_COMPILER);
        FormalismGuiPlugin.getCurrent().removeGuiConfigurator(FSNET_WOC_COMPILER);
        FormalismPlugin.getCurrent().removeCompilerFactory(FSNET_WOC_COMPILER);
        FormalismGuiPlugin.getCurrent().removeGuiConfigurator(XFSNET_COMPILER);
        FormalismPlugin.getCurrent().removeCompilerFactory(XFSNET_COMPILER);
        FormalismGuiPlugin.getCurrent().removeGuiConfigurator(EFSNET_COMPILER);
        FormalismPlugin.getCurrent().removeCompilerFactory(EFSNET_COMPILER);
        try {
            FigureCreatorHolder fc = GuiPlugin.getCurrent().getFigureCreatorHolder();
            if (this._fsFigureCreator != null) {
                fc.unregisterCreator(this._fsFigureCreator);
                this._fsFigureCreator = null;
            }
            if (this._fsTextFigureCreator != null) {
                fc.unregisterCreator(this._fsTextFigureCreator);
                this._fsTextFigureCreator = null;
            }
        }
        catch (NullPointerException e) {
            LOGGER.error((Object)("Could not cleanup: " + String.valueOf(e)), (Throwable)e);
        }
        return true;
    }

    public static FSPlugin getCurrent() {
        for (IPlugin plugin : PluginManager.getInstance().getPluginsProviding("de.renew.fs")) {
            if (!(plugin instanceof FSPlugin)) continue;
            return (FSPlugin)plugin;
        }
        return null;
    }
}

