/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import collections.CollectionEnumeration;
import collections.HashedMap;
import collections.HashedSet;
import collections.UpdatableMap;
import collections.UpdatableSet;
import de.uni_hamburg.fs.ConjunctiveType;
import de.uni_hamburg.fs.FeatureStructure;
import de.uni_hamburg.fs.JavaObject;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.NoSuchFeatureException;
import de.uni_hamburg.fs.Node;
import de.uni_hamburg.fs.Path;
import de.uni_hamburg.fs.RetypeItem;
import de.uni_hamburg.fs.ToDoItem;
import de.uni_hamburg.fs.Type;
import de.uni_hamburg.fs.UnificationFailure;
import de.uni_hamburg.fs.UnifyItem;
import java.util.Stack;

public class EquivRelation {
    private UpdatableMap _tie = new HashedMap();
    private UpdatableMap _eit = new HashedMap();
    private Stack<ToDoItem> _todo = new Stack();

    public static Node unify(FeatureStructure fs1, FeatureStructure fs2) throws UnificationFailure {
        EquivRelation er = new EquivRelation();
        Node root = fs1.getRoot();
        er.unify(root, fs2.getRoot());
        er.extensionalize();
        return er.rebuild(root);
    }

    public static Node unify(FeatureStructure fs1, Path path, FeatureStructure fs2) throws UnificationFailure {
        Node fs1Root = EquivRelation.addPath(fs1.getRoot(), path);
        EquivRelation er = new EquivRelation();
        er.unify(fs1Root.delta(path), fs2.getRoot());
        er.extensionalize();
        return er.rebuild(fs1Root);
    }

    public static Node unify(FeatureStructure fs, Path path1, Path path2) throws UnificationFailure {
        Node fsRoot = EquivRelation.addPath(EquivRelation.addPath(fs.getRoot(), path1), path2);
        EquivRelation er = new EquivRelation();
        er.unify(fsRoot.delta(path1), fsRoot.delta(path2));
        er.extensionalize();
        return er.rebuild(fsRoot);
    }

    public void unify(Node fs1, Node fs2) throws UnificationFailure {
        this.addUnification(fs1, fs2);
        while (!this._todo.empty()) {
            ToDoItem tdi = this.nextToDoItem();
            tdi.doIt(this);
        }
    }

    private static Node addPath(Node root, Path path) throws UnificationFailure {
        Node pathRoot = EquivRelation.createPath(false, root, path);
        if (pathRoot == null) {
            return root;
        }
        EquivRelation pathER = new EquivRelation();
        pathER.unify(root, pathRoot);
        pathER.extensionalize();
        return pathER.rebuild(root);
    }

    private static Node createPath(boolean infoAdded, Node fs, Path path) throws UnificationFailure {
        Type type = fs.getType();
        if (type instanceof JavaObject) {
            type = new ConjunctiveType(((JavaObject)type)._concept);
        }
        Node copy = type.newNode();
        if (path.isEmpty()) {
            if (!infoAdded) {
                copy = null;
            }
        } else {
            Name feature = path.first();
            if (!infoAdded && !fs.hasFeature(feature)) {
                infoAdded = true;
            }
            try {
                Node nextCopy = EquivRelation.createPath(infoAdded, fs.delta(feature), path.butFirst());
                if (nextCopy == null) {
                    return null;
                }
                copy.setFeature(feature, nextCopy);
            }
            catch (NoSuchFeatureException nsf) {
                throw new UnificationFailure();
            }
        }
        return copy;
    }

    public static boolean canUnify(FeatureStructure fs1, FeatureStructure fs2) {
        EquivRelation er = new EquivRelation();
        try {
            er.unify(fs1.getRoot(), fs2.getRoot());
            er.extensionalize();
            return true;
        }
        catch (UnificationFailure uff) {
            return false;
        }
    }

    public static Node deepCopy(Node root) {
        return new EquivRelation().rebuild(root);
    }

    private void addUnification(Node node1, Node node2) {
        this._todo.push(new UnifyItem(node1, node2));
    }

    private void addRetyping(Node node, Type type) {
        this._todo.push(new RetypeItem(node, type));
    }

    private ToDoItem nextToDoItem() {
        return this._todo.pop();
    }

    private void map(Node fs, Node uni) {
        HashedSet equivClass;
        if (fs.equals(uni)) {
            return;
        }
        if (this._eit.includesKey((Object)fs)) {
            CollectionEnumeration equivClassElems = ((UpdatableSet)this._eit.at((Object)fs)).elements();
            while (equivClassElems.hasMoreElements()) {
                Node memberFS = (Node)equivClassElems.nextElement();
                this.map(memberFS, uni);
            }
            this._eit.removeAt((Object)fs);
        }
        this._tie.putAt((Object)fs, (Object)uni);
        if (this._eit.includesKey((Object)uni)) {
            equivClass = (UpdatableSet)this._eit.at((Object)uni);
        } else {
            equivClass = new HashedSet();
            this._eit.putAt((Object)uni, (Object)equivClass);
        }
        equivClass.include((Object)fs);
    }

    public Node getUnificator(Node fs) {
        if (this._tie.includesKey((Object)fs)) {
            return (Node)this._tie.at((Object)fs);
        }
        return fs;
    }

    void unifyOne(Node fs1, Node fs2) throws UnificationFailure {
        if (fs1.equals(fs2)) {
            return;
        }
        Type unitype = fs1.getType().unify(fs2.getType());
        Node uni = this._eit.includesKey((Object)fs2) && unitype.equals(fs2.getType()) ? fs2 : (this._eit.includesKey((Object)fs1) && unitype.equals(fs1.getType()) ? fs1 : unitype.newNode());
        this.addAllFeatures(uni, fs1);
        this.addAllFeatures(uni, fs2);
        this.addRetypings(uni);
        this.map(fs1, uni);
        this.map(fs2, uni);
    }

    void retypeOne(Node fs, Type type) throws UnificationFailure {
        Type fstype = fs.getType();
        Type unitype = fstype.unify(type);
        if (!unitype.equals(fstype)) {
            Node retyped = unitype.newNode();
            this.addAllFeatures(retyped, fs);
            this.map(fs, retyped);
            this.addRetypings(retyped);
        }
    }

    private void addAllFeatures(Node uni, Node fs) {
        if (!(fs instanceof JavaObject) && !uni.equals(fs)) {
            CollectionEnumeration featenumeration = fs.featureNames();
            while (featenumeration.hasMoreElements()) {
                Name featureName = (Name)featenumeration.nextElement();
                Node fspost = fs.delta(featureName);
                if (uni.hasFeature(featureName)) {
                    Node unipost = uni.delta(featureName);
                    this.addUnification(fspost, unipost);
                    continue;
                }
                if (uni instanceof JavaObject) {
                    throw new RuntimeException("Trying to set feature " + String.valueOf(featureName) + " in " + String.valueOf(uni) + " to " + String.valueOf(fspost));
                }
                uni.setFeature(featureName, fspost);
            }
        }
    }

    private void addRetypings(Node uni) {
        Type unitype = uni.getType();
        if (!(unitype instanceof JavaObject)) {
            CollectionEnumeration feats = uni.featureNames();
            while (feats.hasMoreElements()) {
                Name feat = (Name)feats.nextElement();
                this.addRetyping(uni.delta(feat), unitype.appropType(feat));
            }
        }
    }

    public void extensionalize() {
    }

    public Node rebuild(Node fs) {
        boolean expand;
        Node uni;
        if (this._tie.includesKey((Object)fs)) {
            uni = (Node)this._tie.at((Object)fs);
            expand = this._eit.includesKey((Object)uni);
            if (expand) {
                this._eit.removeAt((Object)uni);
            }
        } else {
            uni = fs.duplicate();
            this._tie.putAt((Object)fs, (Object)uni);
            expand = true;
        }
        if (expand && !(uni instanceof JavaObject)) {
            CollectionEnumeration featenumeration = uni.featureNames();
            while (featenumeration.hasMoreElements()) {
                Name featureName = (Name)featenumeration.nextElement();
                uni.setFeature(featureName, this.rebuild(uni.delta(featureName)));
            }
        }
        return uni;
    }
}

