/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import collections.ArrayEnumeration;
import collections.CollectionEnumeration;
import de.uni_hamburg.fs.EmptyEnumeration;
import de.uni_hamburg.fs.ListNode;
import de.uni_hamburg.fs.Name;
import de.uni_hamburg.fs.NoFeatureNode;
import de.uni_hamburg.fs.NoSuchFeatureException;
import de.uni_hamburg.fs.Node;
import de.uni_hamburg.fs.Type;
import de.uni_hamburg.fs.UnificationFailure;

public class ListType
implements Type {
    public static final int LIST = 0;
    public static final int NELIST = 1;
    public static final int ELIST = 2;
    public static final Name HEAD = new Name("hd");
    public static final Name TAIL = new Name("tl");
    private Type _baseType = null;
    private int _subtype;

    public ListType(Type baseType, int subtype) {
        this._baseType = baseType;
        this._subtype = subtype;
    }

    public ListType(Type baseType) {
        this(baseType, 0);
    }

    public static ListType getList(Type baseType) {
        return new ListType(baseType, 0);
    }

    public static ListType getEList(Type baseType) {
        return new ListType(baseType, 2);
    }

    public static ListType getNEList(Type baseType) {
        return new ListType(baseType, 1);
    }

    public Type getBaseType() {
        return this._baseType;
    }

    public int getSubtype() {
        return this._subtype;
    }

    @Override
    public String getName() {
        return this.getName(this.getBaseType().getName());
    }

    private String getName(String basename) {
        switch (this._subtype) {
            case 2: {
                return "<" + basename + ">";
            }
            case 1: {
                return basename + "+";
            }
            case 0: {
                return basename + "*";
            }
        }
        return "!!!wrong list type!!!";
    }

    @Override
    public String getFullName() {
        return this.getName(this.getBaseType().getFullName());
    }

    @Override
    public boolean isExtensional() {
        return this._subtype != 0;
    }

    @Override
    public boolean isInstanceType() {
        return this.getBaseType().isInstanceType();
    }

    @Override
    public Type getInstanceType() {
        if (this.isInstanceType()) {
            return this;
        }
        return new ListType(this.getBaseType().getInstanceType(), this._subtype);
    }

    @Override
    public boolean isApprop(Name feature) {
        return this._subtype == 1 && (feature.equals(HEAD) || feature.equals(TAIL));
    }

    @Override
    public Type appropType(Name feature) throws NoSuchFeatureException {
        if (this._subtype == 1) {
            if (feature.equals(HEAD)) {
                return this.getBaseType();
            }
            if (feature.equals(TAIL)) {
                return new ListType(this.getBaseType(), 0);
            }
        }
        throw new NoSuchFeatureException(feature, this);
    }

    @Override
    public CollectionEnumeration appropFeatureNames() {
        if (this._subtype == 1) {
            return new ArrayEnumeration((Object[])new Name[]{HEAD, TAIL});
        }
        return EmptyEnumeration.INSTANCE;
    }

    @Override
    public boolean subsumes(Type that) {
        if (that instanceof ListType) {
            ListType thatList = (ListType)that;
            return (this._subtype == 0 || this._subtype == thatList._subtype) && this.getBaseType().subsumes(thatList.getBaseType());
        }
        return false;
    }

    @Override
    public Type unify(Type that) throws UnificationFailure {
        if (that.equals(Type.TOP)) {
            return this;
        }
        if (that instanceof ListType) {
            ListType thatList = (ListType)that;
            if (thatList._subtype + this._subtype != 3) {
                return new ListType(thatList.getBaseType().unify(this.getBaseType()), Math.max(thatList._subtype, this._subtype));
            }
        }
        throw new UnificationFailure();
    }

    @Override
    public boolean canUnify(Type that) {
        if (that.equals(Type.TOP)) {
            return true;
        }
        if (that instanceof ListType) {
            ListType thatList = (ListType)that;
            if (thatList._subtype + this._subtype != 3) {
                return thatList.getBaseType().canUnify(this.getBaseType());
            }
        }
        return false;
    }

    @Override
    public Type mostGeneralExtensionalSupertype(Type that) {
        return null;
    }

    @Override
    public Node newNode() {
        if (this._subtype == 1) {
            return new ListNode(this);
        }
        return new NoFeatureNode(this);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof ListType) {
            ListType thatList = (ListType)that;
            return thatList._subtype == this._subtype && thatList.getBaseType().equals(this.getBaseType());
        }
        return false;
    }

    public int hashCode() {
        return this.getBaseType().hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

