/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hamburg.fs;

import de.uni_hamburg.fs.BasicType;
import de.uni_hamburg.fs.Concept;
import de.uni_hamburg.fs.ConceptSet;
import de.uni_hamburg.fs.ConjunctiveType;
import de.uni_hamburg.fs.ParsedType;
import de.uni_hamburg.fs.Type;
import de.uni_hamburg.fs.TypeSystem;
import de.uni_hamburg.fs.UnificationFailure;

public class ParsedConjunctiveType
implements ParsedType {
    private static final Type STRING_TYPE = new BasicType(String.class);
    private Type _type = null;
    private ConceptSet _concepts = null;
    private boolean _restricted = true;
    private boolean _printAny = true;

    public ParsedConjunctiveType(Concept concept) {
        this(new ConceptSet(concept));
    }

    public ParsedConjunctiveType(ConceptSet concepts) {
        this._concepts = concepts;
    }

    public ParsedConjunctiveType(ConceptSet concepts, boolean restricted) {
        this(concepts);
        this._restricted = restricted;
    }

    public ParsedConjunctiveType(ConceptSet concepts, boolean restricted, boolean noDummyType) {
        this(concepts, noDummyType && restricted);
        this._printAny = noDummyType || !restricted;
    }

    @Override
    public ParsedType unite(ParsedType that) throws UnificationFailure {
        if (that instanceof ParsedConjunctiveType) {
            ParsedConjunctiveType thatPCT = (ParsedConjunctiveType)that;
            ConceptSet united = new ConceptSet(this._concepts);
            united.unite(thatPCT._concepts);
            return new ParsedConjunctiveType(united, this._restricted && thatPCT._restricted, this._printAny || thatPCT._printAny);
        }
        throw new UnificationFailure();
    }

    @Override
    public Type asType() throws UnificationFailure {
        if (this._type == null) {
            this._type = this._concepts.equals(new ConceptSet(TypeSystem.instance().getJavaConcept(String.class))) && this._restricted ? STRING_TYPE : new ConjunctiveType(this._concepts, this._restricted, this._printAny);
        }
        return this._type;
    }

    public boolean equals(Object that) {
        if (that instanceof ParsedConjunctiveType) {
            ParsedConjunctiveType thatPT = (ParsedConjunctiveType)that;
            return this._restricted == thatPT._restricted && this._printAny == thatPT._printAny && this._concepts.equals(thatPT._concepts);
        }
        return false;
    }

    public int hashCode() {
        return this._concepts.hashCode() + (this._restricted ? 0 : 999);
    }

    public String toString() {
        return ConjunctiveType.typeToString(this._restricted, this._printAny, false, this._concepts);
    }
}

