/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import de.renew.plugin.PluginManager;
import java.io.IOException;
import java.io.ObjectInput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;

public class ClassSource {
    public static final Logger logger = Logger.getLogger(ClassSource.class);
    private static ClassLoader _loader = null;
    private static Object _deserializer = null;
    private static Method _deserializeMethod = null;

    private ClassSource() {
    }

    public static synchronized void setClassLoader(ClassLoader newLoader) {
        _loader = newLoader;
        logger.debug((Object)("Configured ClassSource with class loader " + newLoader.toString()));
        try {
            _deserializer = ClassSource.classForName("de.renew.util.ReloadableDeserializerImpl").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            _deserializeMethod = _deserializer.getClass().getDeclaredMethod("readObject", ObjectInput.class);
            logger.debug((Object)("Derived deserializer with class loader " + String.valueOf(_deserializer.getClass().getClassLoader())));
        }
        catch (Exception e) {
            _deserializer = null;
            logger.error((Object)("Cannot generate deserializer: " + String.valueOf(e)), (Throwable)e);
            throw new RuntimeException("Cannot generate deserializer.", e);
        }
    }

    public static synchronized ClassLoader getClassLoader() {
        if (_loader == null) {
            return ClassSource.getDefaultClassLoader();
        }
        return _loader;
    }

    private static ClassLoader getDefaultClassLoader() {
        ClassLoader defaultLoader = PluginManager.getInstance().getBottomClassLoader();
        if (defaultLoader == null) {
            defaultLoader = ClassSource.class.getClassLoader();
        }
        return defaultLoader;
    }

    public static synchronized Class<?> classForName(String name) throws ClassNotFoundException {
        if (_loader == null) {
            logger.debug((Object)("Looking up " + name + " in default class source."));
            return Class.forName(name, true, PluginManager.getInstance().getBottomClassLoader());
        }
        logger.debug((Object)("Looking up " + name + " in class source " + String.valueOf(_loader) + "."));
        return Class.forName(name, true, _loader);
    }

    public static Object readObject(ObjectInput input) throws ClassNotFoundException, IOException {
        if (_deserializer == null) {
            return input.readObject();
        }
        try {
            return _deserializeMethod.invoke(_deserializer, input);
        }
        catch (InvocationTargetException ie) {
            Throwable e = ie.getTargetException();
            if (e instanceof ClassNotFoundException) {
                throw (ClassNotFoundException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

