/*
 * Decompiled with CFR 0.152.
 */
package de.renew.util;

import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public class Lock
implements Serializable {
    public static final Logger logger = Logger.getLogger(Lock.class);
    private transient List<Throwable> _lastLockTraces = new ArrayList<Throwable>();
    private transient Thread _lockingThread = null;
    private transient int _lockCount = 0;

    public synchronized void lock() {
        Thread currentThread = Thread.currentThread();
        while (this._lockingThread != null && !this.mayLock(this._lockingThread)) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)new LockDebugLogEvent("Thread " + String.valueOf(Thread.currentThread()) + " has to wait for lock.", this, this._lockCount, this._lastLockTraces, new Throwable("Waiting thread trace")));
                }
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        ++this._lockCount;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Locked " + String.valueOf(this) + " by Thread: " + String.valueOf(currentThread)));
        }
        if (this._lockCount == 1) {
            this._lockingThread = currentThread;
        }
        if (logger.isDebugEnabled()) {
            this._lastLockTraces.add(new Throwable("Locking thread trace no. " + this._lockCount));
        }
    }

    public synchronized void unlock() {
        this.verify();
        --this._lockCount;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Unlocked " + String.valueOf(this) + " by Thread: " + String.valueOf(Thread.currentThread())));
        }
        if (this._lockCount == 0) {
            this._lockingThread = null;
            this._lastLockTraces.clear();
        }
        this.notify();
    }

    public synchronized void verify() {
        if (!this.mayLock(this._lockingThread)) {
            if (this._lockingThread == null) {
                throw new IllegalStateException("The lock is not locked.");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)new LockDebugLogEvent("The lock was locked by another thread.", this, this._lockCount, this._lastLockTraces, new Throwable("Wrong unlocking thread trace")));
            }
            throw new IllegalStateException("The lock was locked by another thread (" + String.valueOf(this._lockingThread) + ",hc=" + this._lockingThread.hashCode() + " instead of " + String.valueOf(Thread.currentThread()) + ",hc=" + Thread.currentThread().hashCode() + ").");
        }
    }

    protected boolean mayLock(Thread lockingThread) {
        return Thread.currentThread() == lockingThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        Lock lock = this;
        synchronized (lock) {
            if (this._lockCount != 0 || this._lockingThread != null) {
                throw new NotSerializableException("de.renew.util.Lock: " + String.valueOf(this) + " is in use.");
            }
            out.defaultWriteObject();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._lockCount = 0;
        this._lockingThread = null;
        this._lastLockTraces = new ArrayList<Throwable>();
    }

    private record LockDebugLogEvent(String situation, Lock lock, int lockCount, List<Throwable> lastLockTraces, Throwable currentTrace) {
        private LockDebugLogEvent(String situation, Lock lock, int lockCount, List<Throwable> lastLockTraces, Throwable currentTrace) {
            this.situation = situation;
            this.lock = lock;
            this.lockCount = lockCount;
            this.lastLockTraces = new ArrayList<Throwable>(lastLockTraces);
            this.currentTrace = currentTrace;
        }

        @Override
        public String toString() {
            StringWriter writer = new StringWriter();
            PrintWriter out = new PrintWriter(writer);
            out.println(this.situation);
            out.println("Lock: " + String.valueOf(this.lock));
            out.println("Current lock count: " + this.lockCount);
            this.currentTrace.printStackTrace(out);
            for (Throwable trace : this.lastLockTraces) {
                if (trace == null) continue;
                trace.printStackTrace(out);
            }
            return writer.toString();
        }
    }
}

