/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.transform;

import edu.uci.ics.jung.visualization.transform.AffineTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import edu.uci.ics.jung.visualization.transform.shape.ShapeTransformer;
import edu.uci.ics.jung.visualization.util.ChangeEventSupport;
import edu.uci.ics.jung.visualization.util.DefaultChangeEventSupport;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import javax.swing.event.ChangeListener;

public class MutableAffineTransformer
extends AffineTransformer
implements MutableTransformer,
ShapeTransformer,
ChangeEventSupport {
    protected ChangeEventSupport changeSupport = new DefaultChangeEventSupport(this);

    public MutableAffineTransformer() {
    }

    public MutableAffineTransformer(AffineTransform transform) {
        super(transform);
    }

    @Override
    public String toString() {
        return "MutableAffineTransformer using " + this.transform;
    }

    @Override
    public void scale(double scalex, double scaley, Point2D from) {
        AffineTransform xf = AffineTransform.getTranslateInstance(from.getX(), from.getY());
        xf.scale(scalex, scaley);
        xf.translate(-from.getX(), -from.getY());
        this.inverse = null;
        this.transform.preConcatenate(xf);
        this.fireStateChanged();
    }

    @Override
    public void setScale(double scalex, double scaley, Point2D from) {
        this.transform.setToIdentity();
        this.scale(scalex, scaley, from);
    }

    @Override
    public void shear(double shx, double shy, Point2D from) {
        this.inverse = null;
        AffineTransform at = AffineTransform.getTranslateInstance(from.getX(), from.getY());
        at.shear(shx, shy);
        at.translate(-from.getX(), -from.getY());
        this.transform.preConcatenate(at);
        this.fireStateChanged();
    }

    @Override
    public void setTranslate(double tx, double ty) {
        float scalex = (float)this.transform.getScaleX();
        float scaley = (float)this.transform.getScaleY();
        float shearx = (float)this.transform.getShearX();
        float sheary = (float)this.transform.getShearY();
        this.inverse = null;
        this.transform.setTransform(scalex, sheary, shearx, scaley, tx, ty);
        this.fireStateChanged();
    }

    @Override
    public void translate(double offsetx, double offsety) {
        this.inverse = null;
        this.transform.translate(offsetx, offsety);
        this.fireStateChanged();
    }

    @Override
    public void rotate(double theta, Point2D from) {
        AffineTransform rotate = AffineTransform.getRotateInstance(theta, from.getX(), from.getY());
        this.inverse = null;
        this.transform.preConcatenate(rotate);
        this.fireStateChanged();
    }

    @Override
    public void rotate(double radians2, double x, double y) {
        this.inverse = null;
        this.transform.rotate(radians2, x, y);
        this.fireStateChanged();
    }

    @Override
    public void concatenate(AffineTransform xform) {
        this.inverse = null;
        this.transform.concatenate(xform);
        this.fireStateChanged();
    }

    @Override
    public void preConcatenate(AffineTransform xform) {
        this.inverse = null;
        this.transform.preConcatenate(xform);
        this.fireStateChanged();
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    @Override
    public ChangeListener[] getChangeListeners() {
        return this.changeSupport.getChangeListeners();
    }

    @Override
    public void fireStateChanged() {
        this.changeSupport.fireStateChanged();
    }

    @Override
    public void setToIdentity() {
        this.inverse = null;
        this.transform.setToIdentity();
        this.fireStateChanged();
    }
}

