/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.ads;

import com.google.common.math.LongMath;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.automatalib.automata.transducers.MealyMachine;
import net.automatalib.commons.util.Pair;
import net.automatalib.graphs.ads.ADSNode;
import net.automatalib.graphs.ads.impl.ADSSymbolNode;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

public final class ADSUtil {
    private ADSUtil() {
    }

    public static <S, I, O> int computeLength(ADSNode<S, I, O> node) {
        if (node.isLeaf()) {
            return 0;
        }
        return 1 + node.getChildren().values().stream().mapToInt(ADSUtil::computeLength).max().getAsInt();
    }

    public static <S, I, O> int countSymbolNodes(ADSNode<S, I, O> node) {
        if (node.isLeaf()) {
            return 0;
        }
        return 1 + node.getChildren().values().stream().mapToInt(ADSUtil::countSymbolNodes).sum();
    }

    public static <S, I, T, O> Pair<ADSNode<S, I, O>, ADSNode<S, I, O>> buildFromTrace(MealyMachine<S, I, T, O> automaton, Word<I> trace, S state) {
        ADSSymbolNode head;
        Iterator<I> sequenceIter = trace.iterator();
        I input = sequenceIter.next();
        ADSSymbolNode tempADS = head = new ADSSymbolNode(null, input);
        I tempInput = input;
        S tempState = state;
        while (sequenceIter.hasNext()) {
            I nextInput = sequenceIter.next();
            ADSSymbolNode nextNode = new ADSSymbolNode(tempADS, nextInput);
            Object trans = automaton.getTransition(tempState, tempInput);
            assert (trans != null);
            Object oldOutput = automaton.getTransitionOutput(trans);
            tempADS.getChildren().put(oldOutput, nextNode);
            tempADS = nextNode;
            tempState = automaton.getSuccessor(trans);
            tempInput = nextInput;
        }
        return Pair.of(head, tempADS);
    }

    public static <S, I, O> Set<ADSNode<S, I, O>> collectLeaves(ADSNode<S, I, O> root) {
        LinkedHashSet<ADSNode<S, I, O>> result = new LinkedHashSet<ADSNode<S, I, O>>();
        ADSUtil.collectLeavesRecursively(result, root);
        return result;
    }

    private static <S, I, O> void collectLeavesRecursively(Set<ADSNode<S, I, O>> nodes, ADSNode<S, I, O> current) {
        if (current.isLeaf()) {
            nodes.add(current);
        } else {
            for (ADSNode n : current.getChildren().values()) {
                ADSUtil.collectLeavesRecursively(nodes, n);
            }
        }
    }

    public static <S, I, O> Pair<Word<I>, Word<O>> buildTraceForNode(ADSNode<S, I, O> node) {
        ADSNode nodeIter = node;
        WordBuilder inputBuilder = new WordBuilder();
        WordBuilder<O> outputBuilder = new WordBuilder<O>();
        for (ADSNode parentIter = (ADSNode)node.getParent(); parentIter != null; parentIter = (ADSNode)parentIter.getParent()) {
            inputBuilder.append(parentIter.getSymbol());
            outputBuilder.append(ADSUtil.getOutputForSuccessor(parentIter, nodeIter));
            nodeIter = parentIter;
        }
        return Pair.of(inputBuilder.reverse().toWord(), outputBuilder.reverse().toWord());
    }

    public static <S, I, O> O getOutputForSuccessor(ADSNode<S, I, O> node, ADSNode<S, I, O> successor) {
        if (!node.equals(successor.getParent())) {
            throw new IllegalArgumentException("No parent relationship");
        }
        for (Map.Entry entry : node.getChildren().entrySet()) {
            if (!((ADSNode)entry.getValue()).equals(successor)) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException("No child relationship");
    }

    public static long computeMaximumSplittingWordLength(int n, int i, int m3) {
        if (m3 == 2) {
            return n;
        }
        return LongMath.binomial(n, i) - LongMath.binomial(m3 - 1, i - 1) - 1L;
    }
}

