/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.util.automata.predicates;

import java.util.function.Predicate;
import net.automatalib.automata.concepts.TransitionOutput;
import net.automatalib.ts.TransitionPredicate;

final class OutputSatisfies<S, I, T, O>
implements TransitionPredicate<S, I, T> {
    private final TransitionOutput<? super T, ? extends O> transOut;
    private final Predicate<? super O> outputPred;
    private final boolean negate;

    OutputSatisfies(TransitionOutput<? super T, ? extends O> transOut, Predicate<? super O> outputPred) {
        this(transOut, outputPred, false);
    }

    OutputSatisfies(TransitionOutput<? super T, ? extends O> transOut, Predicate<? super O> outputPred, boolean negate) {
        this.transOut = transOut;
        this.outputPred = outputPred;
        this.negate = negate;
    }

    @Override
    public boolean apply(S source, I input, T transition) {
        O out = this.transOut.getTransitionOutput(transition);
        return this.negate ^ this.outputPred.test(out);
    }
}

