/*
 * Decompiled with CFR 0.152.
 */
package net.automatalib.words.abstractimpl;

import java.util.Collection;
import java.util.HashSet;
import net.automatalib.words.Alphabet;
import net.automatalib.words.VPDAlphabet;
import net.automatalib.words.abstractimpl.AbstractAlphabet;

public abstract class AbstractVPDAlphabet<I>
extends AbstractAlphabet<I>
implements VPDAlphabet<I> {
    private final Alphabet<I> internalAlphabet;
    private final Alphabet<I> callAlphabet;
    private final Alphabet<I> returnAlphabet;

    public AbstractVPDAlphabet(Alphabet<I> internalAlphabet, Alphabet<I> callAlphabet, Alphabet<I> returnAlphabet) {
        AbstractVPDAlphabet.validateDisjointness(internalAlphabet, VPDAlphabet.SymbolType.INTERNAL, callAlphabet, returnAlphabet);
        AbstractVPDAlphabet.validateDisjointness(callAlphabet, VPDAlphabet.SymbolType.CALL, returnAlphabet);
        this.internalAlphabet = internalAlphabet;
        this.callAlphabet = callAlphabet;
        this.returnAlphabet = returnAlphabet;
    }

    @Override
    public Alphabet<I> getCallAlphabet() {
        return this.callAlphabet;
    }

    @Override
    public I getCallSymbol(int index) {
        return this.callAlphabet.getSymbol(index);
    }

    @Override
    public int getCallSymbolIndex(I symbol) {
        return this.callAlphabet.getSymbolIndex(symbol);
    }

    @Override
    public int getNumCalls() {
        return this.callAlphabet.size();
    }

    @Override
    public Alphabet<I> getInternalAlphabet() {
        return this.internalAlphabet;
    }

    @Override
    public I getInternalSymbol(int index) {
        return this.internalAlphabet.getSymbol(index);
    }

    @Override
    public int getInternalSymbolIndex(I symbol) {
        return this.internalAlphabet.getSymbolIndex(symbol);
    }

    @Override
    public int getNumInternals() {
        return this.internalAlphabet.size();
    }

    @Override
    public Alphabet<I> getReturnAlphabet() {
        return this.returnAlphabet;
    }

    @Override
    public I getReturnSymbol(int index) {
        return this.returnAlphabet.getSymbol(index);
    }

    @Override
    public int getReturnSymbolIndex(I symbol) {
        return this.returnAlphabet.getSymbolIndex(symbol);
    }

    @Override
    public int getNumReturns() {
        return this.returnAlphabet.size();
    }

    @Override
    public VPDAlphabet.SymbolType getSymbolType(I symbol) {
        if (this.internalAlphabet.containsSymbol(symbol)) {
            return VPDAlphabet.SymbolType.INTERNAL;
        }
        if (this.callAlphabet.containsSymbol(symbol)) {
            return VPDAlphabet.SymbolType.CALL;
        }
        if (this.returnAlphabet.containsSymbol(symbol)) {
            return VPDAlphabet.SymbolType.RETURN;
        }
        throw new IllegalArgumentException("Symbol is not contained in this alphabet");
    }

    @Override
    public int size() {
        return this.internalAlphabet.size() + this.callAlphabet.size() + this.returnAlphabet.size();
    }

    @Override
    public I getSymbol(int index) {
        int localIndex = index;
        if (localIndex < this.internalAlphabet.size()) {
            return this.internalAlphabet.getSymbol(localIndex);
        }
        if ((localIndex -= this.internalAlphabet.size()) < this.callAlphabet.size()) {
            return this.callAlphabet.getSymbol(localIndex);
        }
        if ((localIndex -= this.callAlphabet.size()) < this.returnAlphabet.size()) {
            return this.returnAlphabet.getSymbol(localIndex);
        }
        throw new IllegalArgumentException("Index not within its expected bounds");
    }

    @Override
    public int getSymbolIndex(I symbol) {
        int offset = 0;
        if (this.internalAlphabet.containsSymbol(symbol)) {
            return this.internalAlphabet.getSymbolIndex(symbol);
        }
        offset += this.internalAlphabet.size();
        if (this.callAlphabet.containsSymbol(symbol)) {
            return offset + this.callAlphabet.getSymbolIndex(symbol);
        }
        offset += this.callAlphabet.size();
        if (this.returnAlphabet.containsSymbol(symbol)) {
            return offset + this.returnAlphabet.getSymbolIndex(symbol);
        }
        throw new IllegalArgumentException("Alphabet does not contain the queried symbol");
    }

    @Override
    public boolean containsSymbol(I symbol) {
        return this.internalAlphabet.containsSymbol(symbol) || this.callAlphabet.containsSymbol(symbol) || this.returnAlphabet.containsSymbol(symbol);
    }

    @SafeVarargs
    private static <I> void validateDisjointness(Collection<I> source, VPDAlphabet.SymbolType type, Collection<I> ... rest) {
        HashSet<I> sourceAsSet = new HashSet<I>(source);
        int initialSize = sourceAsSet.size();
        for (Collection<I> c : rest) {
            sourceAsSet.removeAll(c);
        }
        if (sourceAsSet.size() < initialSize) {
            throw new IllegalArgumentException("The set of " + (Object)((Object)type) + " symbols is not disjoint with the sets of other symbols.");
        }
    }
}

