/*
 * Decompiled with CFR 0.152.
 */
package de.renew.splashscreen.impl;

import de.renew.splashscreen.impl.ExtendedProgressBar;
import de.renew.splashscreen.impl.ImagePanel;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.JWindow;
import org.apache.log4j.Logger;

public final class RenewSplashScreen
extends JPanel {
    private static final Logger LOGGER = Logger.getLogger(RenewSplashScreen.class);
    private static final String SPLASH_BACKGROUND = "splashscreen.png";
    private static final Dimension DIMENSION = new Dimension(500, 500);
    private static final int PROGRESS_BAR_PARTS = 6;
    private static final int PROGRESS_BAR_Y = 150;
    private static final int PROGRESS_BAR_HEIGHT = 300;
    private static final double PROGRESS_BAR_WIDTH = 1.5;
    private static final int SPLASH_MARGIN = 10;
    private static final int SPLASH_SCREEN_CLOSE_DELAY = 500;
    private static BufferedImage _img = null;
    private static JWindow _splashScreen;
    private static RenewSplashScreen _renewSplashScreen;
    private ExtendedProgressBar _extendedProgressBar;
    private ImagePanel _imgPanel;

    private RenewSplashScreen() {
        if (_renewSplashScreen == null) {
            this._extendedProgressBar = ExtendedProgressBar.getInstance();
            _renewSplashScreen = this;
        }
    }

    public static synchronized RenewSplashScreen getInstance() {
        if (_renewSplashScreen == null) {
            try {
                _renewSplashScreen = new RenewSplashScreen();
            }
            catch (NoClassDefFoundError e) {
                LOGGER.trace((Object)("Splash screen setup: Caught " + String.valueOf(e)));
                String reason = e.getMessage();
                if (reason != null && reason.contains("sun.awt.X11GraphicsEnvironment")) {
                    LOGGER.info((Object)("Splash screen deactivated by NoClassDefFoundError: " + e.getMessage() + "\nProbably the DISPLAY variable points to an inaccessible X server.\nPlease check the variable and the X server configuration."));
                }
                throw e;
            }
        }
        return _renewSplashScreen;
    }

    public void showSplashScreen() {
        try {
            LOGGER.debug((Object)"Setting up splash screen.");
            this.createBackgroundImage();
            _splashScreen = new JWindow();
            _splashScreen.setSize(DIMENSION);
            _splashScreen.setLayout(null);
            _splashScreen.setBackground(Color.WHITE);
            Container contentPane = _splashScreen.getContentPane();
            contentPane.setBackground(Color.WHITE);
            this._extendedProgressBar.setBounds(RenewSplashScreen.DIMENSION.width / 6, 150, (int)((double)RenewSplashScreen.DIMENSION.width / 1.5), 300);
            contentPane.add(this._extendedProgressBar);
            contentPane.add(this._imgPanel);
            _splashScreen.validate();
            _splashScreen.setLocationRelativeTo(null);
            _splashScreen.setVisible(true);
            _splashScreen.toFront();
        }
        catch (HeadlessException e) {
            LOGGER.info((Object)("Splash screen deactivated by HeadlessException: " + e.getMessage()));
        }
        catch (Exception e) {
            LOGGER.warn((Object)("Exception during splash screen setup: " + String.valueOf(e)), (Throwable)e);
        }
    }

    public void closeSplashScreen() {
        if (_splashScreen != null) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                LOGGER.debug((Object)"Splash screen progress update delay interrupted.  Skipping...");
            }
            LOGGER.debug((Object)"Closing splash screen.");
            _splashScreen.dispose();
            _splashScreen = null;
            this._extendedProgressBar.closeExtendedProgressBar();
            this._extendedProgressBar = null;
            this._imgPanel = null;
            _renewSplashScreen = null;
        }
    }

    private void createBackgroundImage() throws IOException {
        try (InputStream inputStream = this.getClass().getResourceAsStream("/splashscreen.png");){
            if (inputStream != null) {
                _img = ImageIO.read(inputStream);
                DIMENSION.setSize(_img.getWidth() + 20, _img.getHeight() + 20);
            }
        }
        this._imgPanel = new ImagePanel(_img, DIMENSION);
    }

    public void progressBarPropertyChange(PropertyChangeEvent evt) {
        this._extendedProgressBar.propertyChange(evt);
    }
}

