/*
 * Decompiled with CFR 0.152.
 */
package de.renew.fa.figures;

import CH.ifa.draw.figures.ArrowTip;
import CH.ifa.draw.figures.LineConnection;
import CH.ifa.draw.figures.LineDecoration;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.storables.ontology.FigureEnumeration;
import de.renew.fa.figures.FAArcInstanceConnection;
import de.renew.fa.figures.FAStateFigure;
import de.renew.fa.figures.FATextFigure;
import de.renew.faformalism.shadow.ShadowFAArc;
import de.renew.faformalism.shadow.ShadowFAState;
import de.renew.gui.FigureWithHighlight;
import de.renew.gui.InscribableFigure;
import de.renew.gui.InstanceDrawing;
import de.renew.gui.InstanceFigure;
import de.renew.gui.ShadowHolder;
import de.renew.gui.SimulableFigure;
import de.renew.remote.ObjectAccessor;
import de.renew.simulatorontology.shadow.ShadowNet;
import de.renew.simulatorontology.shadow.ShadowNetElement;
import java.awt.Graphics;
import java.io.Serializable;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class FAArcConnection
extends LineConnection
implements InscribableFigure,
FigureWithHighlight,
SimulableFigure {
    static final long serialVersionUID = 1968826680828590162L;
    public static final Logger LOGGER = Logger.getLogger(FAArcConnection.class);
    private transient ShadowFAArc _shadow = null;
    private Figure _hilightFig = null;

    public FAArcConnection() {
        super(null, (LineDecoration)new ArrowTip(), "");
    }

    public FAArcConnection(LineDecoration start, LineDecoration end, String lineStyle) {
        super(start, end, lineStyle);
    }

    public ShadowNetElement buildShadow(ShadowNet net) {
        LOGGER.debug((Object)("buildShadow(ShadowNet) called by " + String.valueOf((Object)this)));
        if (this._shadow != null) {
            this._shadow.discard();
        }
        this._shadow = new ShadowFAArc(this.startShadow(), this.endShadow());
        this._shadow.setContext((Object)this);
        this._shadow.setID(this.getID());
        this._shadow.setTrace(this.getTraceMode());
        LOGGER.debug((Object)("built " + String.valueOf(this._shadow)));
        return this._shadow;
    }

    private ShadowFAState startShadow() {
        return (ShadowFAState)((ShadowHolder)this.startFigure()).getShadow();
    }

    private ShadowFAState endShadow() {
        return (ShadowFAState)((ShadowHolder)this.endFigure()).getShadow();
    }

    public ShadowNetElement getShadow() {
        return this._shadow;
    }

    public InstanceFigure createInstanceFigure(InstanceDrawing drawing, Hashtable<Serializable, ObjectAccessor> netElements) {
        return new FAArcInstanceConnection(drawing, this, netElements);
    }

    public boolean canConnect(Figure start, Figure end) {
        return start instanceof FAStateFigure && end instanceof FAStateFigure;
    }

    public boolean getTraceMode() {
        Object value = this.getAttribute("TraceMode");
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return true;
    }

    public void setHighlightFigure(Figure fig) {
        this._hilightFig = fig;
    }

    public Figure getHighlightFigure() {
        return this._hilightFig;
    }

    public String getName() {
        String cln = ((Object)((Object)this)).getClass().getName();
        int ind = cln.lastIndexOf(46) + 1;
        if (ind > 0) {
            cln = cln.substring(ind);
        }
        FigureEnumeration children = this.children();
        while (children.hasMoreElements()) {
            FATextFigure textFig;
            Figure child = (Figure)children.nextElement();
            if (!(child instanceof FATextFigure) || (textFig = (FATextFigure)child).getType() != 2) continue;
            return cln + "(" + textFig.getText() + ")";
        }
        return cln + " (" + this.getID() + ")";
    }

    public String toString() {
        return this.getName();
    }

    public void drawFrame(Graphics g) {
        super.setEndDecoration();
        super.setStartDecoration(null);
        super.drawFrame(g);
    }
}

