/*
 * Decompiled with CFR 0.152.
 */
package de.renew.fa.figures;

import CH.ifa.draw.figures.ConnectedTextTool;
import CH.ifa.draw.figures.TextFigure;
import CH.ifa.draw.framework.ChildFigure;
import CH.ifa.draw.framework.ParentFigure;
import CH.ifa.draw.standard.TextHolder;
import de.renew.draw.storables.ontology.Figure;
import de.renew.draw.ui.ontology.DrawingEditor;
import de.renew.faformalism.util.FAAutomatonModelEnum;
import de.renew.faformalism.util.SimulationSettingsManager;
import java.awt.event.MouseEvent;

public class FATextFigureCreationTool
extends ConnectedTextTool {
    public static final int FA_TOOL_TYPE_WORD = 0;
    public static final int FA_TOOL_TYPE_INSCRIPTION = 1;
    private final int _type;

    public FATextFigureCreationTool(DrawingEditor editor, TextFigure prototype, int type) {
        super(editor, prototype);
        this._type = type;
    }

    public void mouseDown(MouseEvent e, int x, int y) {
        if (!this._connected && !this.isTypingActive()) {
            Figure pressedFigure = this.drawing().findFigureInside(x, y);
            if (pressedFigure instanceof ParentFigure && ((ChildFigure)this.getPrototype()).canBeParent((ParentFigure)pressedFigure)) {
                super.mouseDown(e, x, y);
                Figure figure = this.createdFigure();
                if (figure instanceof TextFigure) {
                    TextFigure textFigure = (TextFigure)figure;
                    textFigure.setText(FATextFigureCreationTool.getTextForModel(this._type, SimulationSettingsManager.getAutomatonModel()));
                    this.beginEdit((TextHolder)textFigure);
                }
            } else {
                super.mouseDown(e, x, y);
            }
        } else {
            super.mouseDown(e, x, y);
        }
    }

    public static String getTextForModel(int type, FAAutomatonModelEnum automatonModel) {
        if (type == 0) {
            switch (automatonModel) {
                case NFA: 
                case NET: {
                    return "a*+b^+";
                }
                case BUECHI: {
                    return "a*+b^\u00b0";
                }
                case PDA: {
                    return "abc";
                }
            }
        }
        if (type == 1) {
            switch (automatonModel) {
                case NFA: 
                case NET: 
                case BUECHI: {
                    return "a";
                }
                case PDA: {
                    return "a, -> X";
                }
            }
        }
        return "";
    }
}

