/*
 * Decompiled with CFR 0.152.
 */
package de.renew.fa.gui;

import de.renew.fa.gui.FASimulationSettingsInterface;
import de.renew.faformalism.util.FAAutomatonModelEnum;
import de.renew.faformalism.util.SimulationSettingsManager;
import de.renew.formalism.FormalismPlugin;
import de.renew.simulator.api.SimulationManager;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class FASimulationSettingsGui
implements FASimulationSettingsInterface {
    private final JFrame _frame;
    private final JPanel _textFieldPanel = new JPanel();
    private final JComboBox<FAAutomatonModelEnum> _automatonModelComboBox;
    private boolean _simulateWordMode = true;
    private boolean _manualSimulation = true;
    private JRadioButton _manual;
    private JButton _simulateWordModeButton;
    private ActionListener _simulateWordModeActionListener;
    private ActionListener _manualSimulationActionListener;
    private ActionListener _automationModelComboBoxActionListener;
    private FAAutomatonModelEnum _previousSelection = FAAutomatonModelEnum.NFA;
    private static final FAAutomatonModelEnum[] MODELS = new FAAutomatonModelEnum[]{FAAutomatonModelEnum.NFA, FAAutomatonModelEnum.BUECHI, FAAutomatonModelEnum.PDA};

    FASimulationSettingsGui() {
        this._frame = new JFrame("FA Automaton Settings");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        final JPanel modePanel = new JPanel();
        modePanel.setLayout(new BoxLayout(modePanel, 0));
        modePanel.add(this.createHorizontalFiller());
        this._simulateWordModeButton = new JButton("Switch Mode");
        final JLabel currentMode = new JLabel("<html><B>Current Mode:</B> Simulate Word</html>");
        this._simulateWordModeActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SimulationManager.isSimulationActive()) {
                    return;
                }
                Object text = "<html><B>Current Mode:</B> ";
                if (!FASimulationSettingsGui.this._simulateWordMode) {
                    text = (String)text + "Simulate Word";
                } else {
                    text = (String)text + "Build Word";
                    FASimulationSettingsGui.this._manualSimulation = true;
                    FASimulationSettingsGui.this._manual.setSelected(true);
                }
                FASimulationSettingsGui.this._simulateWordMode = !FASimulationSettingsGui.this._simulateWordMode;
                SimulationSettingsManager.setSimulateWordMode((boolean)FASimulationSettingsGui.this._simulateWordMode);
                currentMode.setText((String)text + "</html>");
                modePanel.revalidate();
                modePanel.repaint();
                FASimulationSettingsGui.this._textFieldPanel.revalidate();
                FASimulationSettingsGui.this._textFieldPanel.repaint();
            }
        };
        this._simulateWordModeButton.addActionListener(this._simulateWordModeActionListener);
        modePanel.add(currentMode);
        modePanel.add(this._simulateWordModeButton);
        JPanel modelPanel = new JPanel();
        modelPanel.setLayout(new BoxLayout(modelPanel, 0));
        modelPanel.add(this.createHorizontalFiller());
        this._automatonModelComboBox = new JComboBox<FAAutomatonModelEnum>(MODELS);
        FAAutomatonModelEnum current = SimulationSettingsManager.getAutomatonModel();
        if (current != FAAutomatonModelEnum.NET) {
            this._automatonModelComboBox.setSelectedItem(SimulationSettingsManager.getAutomatonModel());
        } else {
            this._automatonModelComboBox.setSelectedItem(this._previousSelection);
        }
        this._automationModelComboBoxActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SimulationManager.isSimulationActive()) {
                    FASimulationSettingsGui.this._automatonModelComboBox.setSelectedItem(FASimulationSettingsGui.this._previousSelection);
                    return;
                }
                FASimulationSettingsGui.this._previousSelection = (FAAutomatonModelEnum)FASimulationSettingsGui.this._automatonModelComboBox.getSelectedItem();
                SimulationSettingsManager.setAutomatonModel((FAAutomatonModelEnum)FASimulationSettingsGui.this._previousSelection);
            }
        };
        this._automatonModelComboBox.addActionListener(this._automationModelComboBoxActionListener);
        modelPanel.add(this._automatonModelComboBox);
        modelPanel.add(this.createHorizontalFiller());
        JPanel manualPanel = new JPanel();
        manualPanel.setLayout(new BoxLayout(manualPanel, 0));
        manualPanel.add(this.createHorizontalFiller());
        this._manual = new JRadioButton("Manual simulation");
        this._manual.setSelected(true);
        this._manualSimulationActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (SimulationManager.isSimulationActive() || !FASimulationSettingsGui.this._simulateWordMode) {
                    FASimulationSettingsGui.this._manual.setSelected(FASimulationSettingsGui.this._manualSimulation);
                    return;
                }
                FASimulationSettingsGui.this._manualSimulation = !FASimulationSettingsGui.this._manualSimulation;
                SimulationSettingsManager.setManualSimulation((boolean)FASimulationSettingsGui.this._manualSimulation);
            }
        };
        this._manual.addActionListener(this._manualSimulationActionListener);
        manualPanel.add(this._manual);
        manualPanel.add(this.createHorizontalFiller());
        mainPanel.add(modePanel);
        mainPanel.add(modelPanel);
        mainPanel.add(manualPanel);
        mainPanel.add(this._textFieldPanel);
        this._frame.add(mainPanel);
        this._frame.setDefaultCloseOperation(1);
        this._frame.pack();
        this._frame.setMinimumSize(this._frame.getSize());
    }

    private Box.Filler createHorizontalFiller() {
        return new Box.Filler(new Dimension(0, 0), new Dimension(20, 0), new Dimension(1000, 0));
    }

    @Override
    public FAAutomatonModelEnum getSelectedAutomatonType() {
        return (FAAutomatonModelEnum)this._automatonModelComboBox.getSelectedItem();
    }

    @Override
    public boolean simulateWordMode() {
        return this._simulateWordMode;
    }

    @Override
    public void showGui() {
        FormalismPlugin fp = FormalismPlugin.getCurrent();
        if (fp != null && !fp.getCompiler().equals("FA Automaton Compiler")) {
            String message = "The current formalism is not affected by the settings chosen from this menu.\n Chose the \"FA Automaton Compiler\" if you want to simulate automata processing expressions.";
            JOptionPane.showMessageDialog(new JFrame(), message, "Wrong Formalism", 0);
            return;
        }
        this._frame.setVisible(true);
        this._frame.setState(0);
        this._frame.toFront();
        this._frame.repaint();
    }

    @Override
    public void cleanup() {
        this._frame.dispose();
    }
}

